/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.openmicroscopy.shoola.util.roi.ROIComponent;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;
import org.openmicroscopy.shoola.util.roi.exception.ROICreationException;
import org.openmicroscopy.shoola.util.roi.io.InputStrategy;
import org.openmicroscopy.shoola.util.roi.io.OutputStrategy;
import org.openmicroscopy.shoola.util.roi.model.ROI;

public class XMLFileIOStrategy {
    private OutputStrategy outputStrategy = new OutputStrategy();
    private InputStrategy inputStrategy = new InputStrategy();

    public void reset() {
        this.inputStrategy.reset();
    }

    public List<ROI> read(InputStream input, ROIComponent component) throws NoSuchROIException, ParsingException, ROICreationException, ROICreationException {
        if (input == null) {
            throw new NullPointerException("No input stream specified.");
        }
        List<ROI> roiList = this.inputStrategy.readROI(input, component);
        try {
            input.close();
        }
        catch (IOException e) {
            throw new ParsingException("Unable to close input file.");
        }
        return roiList;
    }

    public void write(OutputStream output, ROIComponent component) throws ParsingException {
        if (output == null) {
            throw new NullPointerException("No input stream specified.");
        }
        this.outputStrategy.write(output, component);
        try {
            output.close();
        }
        catch (IOException e) {
            throw new ParsingException("Unable to close output file.");
        }
    }
}

