/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.model.util;

import java.io.Serializable;
import java.util.Comparator;

public class Coord3D
implements Comparator,
Serializable {
    static final int ZTBITSPLIT = 18;
    private int t;
    private int z;
    private int c;

    public Coord3D() {
        this(0, 0);
    }

    public Coord3D(int zsec, int time) {
        this.t = time;
        this.z = zsec;
        this.c = -1;
    }

    public int getChannel() {
        return this.c;
    }

    public void setChannel(int c) {
        this.c = c;
    }

    public int getTimePoint() {
        return this.t;
    }

    public int getZSection() {
        return this.z;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Coord3D)) {
            return false;
        }
        Coord3D comp = (Coord3D)obj;
        return comp.t == this.t && comp.z == this.z;
    }

    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof Coord3D) || !(o2 instanceof Coord3D)) {
            return -1;
        }
        Coord3D a = (Coord3D)o1;
        Coord3D b = (Coord3D)o2;
        if (a.z < 0 || b.z < 0) {
            return 0;
        }
        if (a.t < b.t) {
            return -1;
        }
        if (a.t > b.t) {
            return 1;
        }
        if (a.z < b.z) {
            return -1;
        }
        if (a.z > b.z) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int value = this.z << 18 + this.t;
        return value;
    }

    public String toString() {
        return "T: " + this.t + " Z: " + this.z;
    }
}

