/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.openmicroscopy.shoola.util.ui.AnimatedPane;
import org.openmicroscopy.shoola.util.ui.border.OneLineBorder;

public class AnimatedJFrame
extends JFrame
implements ActionListener {
    public static final float DURATION = 300.0f;
    public static final int SLEEP = 20;
    private static final int INCOMING = 1;
    public static final int OUTGOING = -1;
    public static final int UP_MIDDLE = 0;
    public static final int DOWN = 1;
    public static final int UP_RIGHT = 2;
    public static final int UP_LEFT = 3;
    private static final Color LINE_COLOR = Color.black;
    private float duration;
    private int sleep;
    private JPanel glass;
    private boolean animating;
    private int animationDir;
    private AnimatedPane animatingPane;
    private long animationStart;
    private Timer animationTimer;
    private JComponent sheet;
    private int orientation;
    private OneLineBorder border;
    private boolean closeAfter;
    private Timer timer;
    private Point location;

    private void initialize() {
        this.location = new Point(0, 0);
        this.duration = 300.0f;
        this.sleep = 20;
        this.animatingPane = new AnimatedPane(this);
        this.animatingPane.requestFocus();
        this.glass = (JPanel)this.getGlassPane();
        this.glass.setLayout(new GridBagLayout());
        this.setOrientation(1);
    }

    private void startAnimation() {
        this.glass.remove(this.animatingPane);
        this.glass.remove(this.sheet);
        this.glass.validate();
        this.glass.repaint();
        this.animatingPane.setSource(this.sheet);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        switch (this.orientation) {
            case 1: {
                c.anchor = 11;
                this.glass.add((Component)this.animatingPane, c);
                ++c.gridy;
                c.weighty = 2.147483647E9;
                this.glass.add(Box.createGlue(), c);
                break;
            }
            case 0: {
                int h = this.glass.getHeight() - this.sheet.getHeight() - this.location.y;
                if (this.glass.getLayout() == null) {
                    Dimension d = this.getSize();
                    int w = (d.width - this.sheet.getPreferredSize().width) / 2;
                    this.animatingPane.setLocation(w, h);
                    this.glass.add(this.animatingPane);
                    break;
                }
                this.glass.add(Box.createVerticalStrut(h), c);
                c.weightx = 0.5;
                ++c.gridy;
                this.glass.add((Component)this.animatingPane, c);
                break;
            }
            case 2: {
                c.anchor = 14;
                int h = this.glass.getHeight() - this.sheet.getHeight() - this.location.y;
                this.glass.add(Box.createVerticalStrut(h), c);
                c.weightx = 0.9;
                ++c.gridy;
                this.glass.add((Component)this.animatingPane, c);
                break;
            }
            case 3: {
                int h = this.glass.getHeight() - this.sheet.getHeight() - this.location.y;
                if (this.glass.getLayout() == null) {
                    this.animatingPane.setLocation(0, h);
                    this.glass.add(this.animatingPane);
                    break;
                }
                c.anchor = 16;
                this.glass.add(Box.createVerticalStrut(h), c);
                c.weightx = 0.1;
                ++c.gridy;
                this.glass.add((Component)this.animatingPane, c);
            }
        }
        this.glass.setVisible(true);
        this.animationStart = System.currentTimeMillis();
        if (this.animationTimer == null) {
            this.animationTimer = new Timer(this.sleep, this);
        }
        this.animating = true;
        this.animationTimer.start();
    }

    private void stopAnimation() {
        this.animationTimer.stop();
        this.animating = false;
    }

    private void finish() {
        this.glass.remove(this.animatingPane);
        this.glass.remove(this.sheet);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 16;
        switch (this.orientation) {
            case 1: {
                c.anchor = 11;
                this.glass.add((Component)this.sheet, c);
                ++c.gridy;
                c.weighty = 2.147483647E9;
                this.glass.add(Box.createGlue(), c);
                break;
            }
            case 0: {
                int h = this.glass.getHeight() - this.sheet.getHeight() - this.location.y;
                if (this.glass.getLayout() == null) {
                    Dimension d = this.getSize();
                    int w = (d.width - this.sheet.getPreferredSize().width) / 2;
                    this.sheet.setLocation(w, h);
                    this.glass.add(this.sheet);
                    break;
                }
                this.glass.add(Box.createVerticalStrut(h), c);
                ++c.gridy;
                this.glass.add((Component)this.sheet, c);
                break;
            }
            case 2: {
                int h = this.glass.getHeight() - this.sheet.getHeight() - this.location.y;
                this.glass.add(Box.createVerticalStrut(h), c);
                ++c.gridy;
                Dimension d = this.getSize();
                int w = d.width - this.sheet.getPreferredSize().width;
                this.glass.add(Box.createHorizontalStrut(w), c);
                ++c.gridx;
                this.glass.add((Component)this.sheet, c);
                break;
            }
            case 3: {
                int h = this.glass.getHeight() - this.sheet.getHeight() - this.location.y;
                if (this.glass.getLayout() == null) {
                    this.sheet.setLocation(0, h);
                    this.glass.add(this.sheet);
                    break;
                }
                this.glass.add(Box.createVerticalStrut(h), c);
                ++c.gridy;
                c.weightx = 0.1;
                ++c.gridx;
                this.glass.add((Component)this.sheet, c);
            }
        }
        this.glass.revalidate();
        this.glass.repaint();
        if (this.closeAfter) {
            if (this.timer == null) {
                this.timer = new Timer(500, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AnimatedJFrame.this.hideAnimation();
                    }
                });
                this.timer.setInitialDelay(2000);
                this.timer.setRepeats(false);
            }
            this.timer.start();
        }
    }

    public AnimatedJFrame(String title) {
        super(title);
        this.initialize();
    }

    public void setCloseAfter(boolean closeAfter) {
        this.closeAfter = closeAfter;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setDuration(float duration) {
        if (duration <= 0.0f) {
            duration = 300.0f;
        }
        this.duration = duration;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }

    public void setOrientation(int orientation) {
        switch (orientation) {
            case 0: 
            case 2: 
            case 3: {
                this.orientation = orientation;
                this.border = new OneLineBorder(1, LINE_COLOR);
                break;
            }
            default: {
                this.orientation = 1;
                this.border = new OneLineBorder(0, LINE_COLOR);
            }
        }
        if (this.sheet != null) {
            this.sheet.setBorder(this.border);
        }
        this.animatingPane.setBorder(this.border);
    }

    public JComponent showJDialogAsSheet(JDialog dialog, Point location) {
        return this.showJDialogAsSheet(dialog, location, 1);
    }

    public JComponent showJDialogAsSheet(JDialog dialog, Point location, int orientation) {
        if (dialog == null) {
            return null;
        }
        this.location = location;
        this.sheet = (JComponent)dialog.getContentPane();
        if (this.glass.getLayout() == null) {
            this.animatingPane.setSize(dialog.getSize());
            this.animatingPane.setPreferredSize(dialog.getPreferredSize());
            this.sheet.setSize(dialog.getSize());
            this.sheet.setPreferredSize(dialog.getPreferredSize());
            this.glass.remove(this.animatingPane);
            this.glass.remove(this.sheet);
        } else {
            this.glass.removeAll();
        }
        this.setOrientation(orientation);
        this.glass.validate();
        this.glass.repaint();
        this.animationDir = 1;
        this.startAnimation();
        return this.sheet;
    }

    public void hideAnimation(boolean visible) {
        this.animationDir = -1;
        this.glass.remove(this.animatingPane);
        this.glass.remove(this.sheet);
        this.glass.validate();
        this.glass.repaint();
        this.stopAnimation();
        this.glass.setVisible(visible);
        if (this.timer != null && this.closeAfter) {
            this.timer.stop();
        }
    }

    public void hideAnimation() {
        this.hideAnimation(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.animating) {
            return;
        }
        if (this.sheet == null) {
            if (this.timer != null) {
                this.timer.stop();
            }
            return;
        }
        float percent = System.currentTimeMillis() - this.animationStart;
        percent /= 300.0f;
        percent = Math.min(1.0f, percent);
        int h = 0;
        h = this.animationDir == 1 ? (int)(percent * (float)this.sheet.getHeight()) : (int)((1.0f - percent) * (float)this.sheet.getHeight());
        this.animatingPane.setAnimatingHeight(h);
        this.animatingPane.repaint();
        if (percent >= 1.0f) {
            this.stopAnimation();
            if (this.animationDir == 1) {
                this.finish();
            } else {
                this.glass.removeAll();
                this.glass.setVisible(false);
            }
        }
    }
}

