/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.openmicroscopy.shoola.util.ui.ColourIcon;

public class ColorListRenderer
extends JLabel
implements ListCellRenderer {
    private static final int GAP = 20;
    private static ColourIcon icon;
    private Border lineBorder;
    private Border emptyBorder;

    public ColorListRenderer() {
        this.setOpaque(true);
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(0);
        this.setIconTextGap(20);
        icon = new ColourIcon(12, 12);
        this.lineBorder = BorderFactory.createLineBorder(Color.gray, 1);
        this.emptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        if (value == null) {
            return this;
        }
        Object[] array = (Object[])value;
        if (array.length != 2) {
            return this;
        }
        if (array[0] != null) {
            if (array[0] instanceof Color) {
                Color c = (Color)array[0];
                icon.setColour(new Color(c.getRed(), c.getGreen(), c.getBlue()));
                icon.setLookupTable(null);
            } else if (array[0] instanceof String) {
                icon.setLookupTable((String)array[0]);
            }
        }
        this.setIcon(icon);
        this.setText((String)array[1]);
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        if (hasFocus) {
            this.setBorder(this.lineBorder);
        } else {
            this.setBorder(this.emptyBorder);
        }
        return this;
    }
}

