/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class FrameBorder
extends AbstractBorder {
    public static Color DEFAULT_COLOR = Color.WHITE;
    private int margin;
    private Color lineColor;
    private Color backgroundColor;
    private Insets insets;

    public FrameBorder(Color lineColor) {
        this(lineColor, DEFAULT_COLOR, 0);
    }

    public FrameBorder(Color lineColor, int margin) {
        this(lineColor, DEFAULT_COLOR, margin);
    }

    public FrameBorder(Color lineColor, Color backgroundColor, int margin) {
        if (lineColor == null) {
            lineColor = DEFAULT_COLOR;
        }
        if (backgroundColor == null) {
            backgroundColor = DEFAULT_COLOR;
        }
        if (margin < 0) {
            margin = 0;
        }
        this.lineColor = lineColor;
        this.backgroundColor = backgroundColor;
        this.margin = margin;
        this.insets = new Insets(margin + 1, margin + 1, margin + 1, margin + 1);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setBackgroundColor(Color c) {
        this.backgroundColor = c == null ? DEFAULT_COLOR : c;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color originalColor = g.getColor();
        g.setColor(this.backgroundColor);
        for (int i = 0; i < this.margin; ++i) {
            g.drawRect(x + i, y + i, width - 2 * i - 1, height - 2 * i - 1);
        }
        g.setColor(this.lineColor);
        g.drawRect(x + this.margin, y + this.margin, width - 2 * this.margin - 1, height - 2 * this.margin - 1);
        g.setColor(originalColor);
    }
}

