/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import java.awt.Color;
import java.util.Objects;

public class LookupTableItem
implements Comparable<LookupTableItem> {
    public static final LookupTableItem SEPARATOR = new LookupTableItem("---");
    private String filename;
    private Color color;
    private String label;

    public LookupTableItem(String filename) {
        this.filename = filename;
        this.label = this.generateLabel(filename);
    }

    public LookupTableItem(Color color, String label) {
        this.color = color;
        this.label = label;
    }

    private String generateLabel(String filename) {
        filename = filename.replace(".lut", "");
        String[] parts = filename.replace(".lut", "").split("_");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            sb.append(part.substring(0, 1).toUpperCase());
            if (part.length() > 1) {
                sb.append(part.substring(1));
            }
            if (i >= parts.length - 1) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public boolean hasLookupTable() {
        return this.filename != null;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.getLabel();
    }

    public String getFilename() {
        return this.filename;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean matchesFilename(String filename) {
        return this.filename == null ? false : this.filename.equals(filename);
    }

    @Override
    public int compareTo(LookupTableItem o) {
        return this.label.compareTo(o.label);
    }

    public int hashCode() {
        return Objects.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Objects.equals(this, obj);
    }
}

