/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import java.awt.Color;
import java.util.Collection;

class RGBModel {
    private float originalRed;
    private float originalGreen;
    private float originalBlue;
    private float originalAlpha;
    private float red;
    private float green;
    private float blue;
    private float alpha;
    private Collection<String> availableLUTs;
    private String originalLut;
    private String lut;
    private boolean revInt;
    private boolean originalRevInt;

    private void setV(float v, boolean reset) {
        float[] vals = this.RGBtoHSV();
        vals[2] = v;
        float[] rgb = this.HSVtoRGB(vals[0], vals[1], vals[2]);
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
        if (reset) {
            this.originalRed = this.red;
            this.originalGreen = this.green;
            this.originalBlue = this.blue;
            this.originalAlpha = this.alpha;
        }
    }

    private void setH(float h, boolean reset) {
        float[] vals = this.RGBtoHSV();
        vals[0] = h;
        float[] rgb = this.HSVtoRGB(vals[0], vals[1], vals[2]);
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
        if (reset) {
            this.originalRed = this.red;
            this.originalGreen = this.green;
            this.originalBlue = this.blue;
        }
    }

    private void setS(float s, boolean reset) {
        float[] vals = this.RGBtoHSV();
        vals[1] = s;
        float[] rgb = this.HSVtoRGB(vals[0], vals[1], vals[2]);
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
        if (reset) {
            this.originalRed = this.red;
            this.originalGreen = this.green;
            this.originalBlue = this.blue;
        }
    }

    RGBModel(float r, float g, float b, float a, String lut, Collection<String> availableLUTs, boolean revInt) {
        this.originalRed = r;
        this.originalGreen = g;
        this.originalBlue = b;
        this.originalAlpha = a;
        this.originalLut = lut;
        this.red = r;
        this.green = g;
        this.blue = b;
        this.alpha = a;
        this.lut = lut;
        this.availableLUTs = availableLUTs;
        this.revInt = revInt;
        this.originalRevInt = revInt;
    }

    float getRed() {
        return this.red;
    }

    float getGreen() {
        return this.green;
    }

    float getBlue() {
        return this.blue;
    }

    float getAlpha() {
        return this.alpha;
    }

    float getHue() {
        float[] vals = this.RGBtoHSV();
        return vals[0];
    }

    float getSaturation() {
        float[] vals = this.RGBtoHSV();
        return vals[1];
    }

    float getValue() {
        float[] vals = this.RGBtoHSV();
        return vals[2];
    }

    void setValue(float v, boolean reset) {
        this.setV(v, reset);
    }

    void setValue(float v) {
        this.setValue(v, false);
    }

    void setHue(float h, boolean reset) {
        this.setH(h, reset);
    }

    void setHue(float h) {
        this.setH(h, false);
    }

    void setSaturation(float s, boolean reset) {
        this.setS(s, reset);
    }

    void setSaturation(float s) {
        this.setSaturation(s, false);
    }

    void setRed(float r, boolean reset) {
        this.red = r;
        if (reset) {
            this.originalRed = this.red;
        }
    }

    void setRed(float r) {
        this.setRed(r, false);
    }

    void setGreen(float g, boolean reset) {
        this.green = g;
        if (reset) {
            this.originalGreen = this.green;
        }
    }

    void setGreen(float g) {
        this.setGreen(g, false);
    }

    void setBlue(float b, boolean reset) {
        this.blue = b;
        if (reset) {
            this.originalBlue = this.blue;
        }
    }

    void setBlue(float b) {
        this.setBlue(b, false);
    }

    void setAlpha(float a, boolean reset) {
        this.alpha = a;
        if (reset) {
            this.originalAlpha = this.alpha;
        }
    }

    void setAlpha(float a) {
        this.setAlpha(a, false);
    }

    void setColour(Color c, boolean reset) {
        this.red = (float)c.getRed() / 255.0f;
        this.green = (float)c.getGreen() / 255.0f;
        this.blue = (float)c.getBlue() / 255.0f;
        if (reset) {
            this.originalRed = this.red;
            this.originalGreen = this.green;
            this.originalBlue = this.blue;
        }
    }

    void setColour(Color c) {
        this.setColour(c, false);
    }

    void setRGBColour(float r, float g, float b, float a, boolean reset) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.alpha = a;
        if (reset) {
            this.originalRed = this.red;
            this.originalGreen = this.green;
            this.originalBlue = this.blue;
            this.originalAlpha = this.alpha;
        }
    }

    void setRGBColour(float r, float g, float b, float a) {
        this.setRGBColour(r, g, b, a, false);
    }

    void setHSVColour(float h, float s, float v, float a, boolean reset) {
        float[] rgb = this.HSVtoRGB(h, s, v);
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
        this.alpha = a;
        if (reset) {
            this.originalRed = this.red;
            this.originalGreen = this.green;
            this.originalBlue = this.blue;
            this.originalAlpha = this.alpha;
        }
    }

    void setHSVColour(float h, float s, float v, float a) {
        this.setHSVColour(h, s, v, a, false);
    }

    Color getColour() {
        return new Color(this.red, this.green, this.blue, this.alpha);
    }

    float[] RGBtoHSV() {
        float s;
        float max;
        float[] hsv = new float[3];
        float min = this.findMin(this.red, this.green, this.blue);
        float v = max = this.findMax(this.red, this.green, this.blue);
        float delta = max - min;
        if (max != 0.0f) {
            s = delta / max;
        } else {
            v = 0.0f;
            s = 0.0f;
            float f = 0.0f;
        }
        float h = 0.0f;
        if ((double)Math.abs(this.red - max) < 1.0E-5) {
            h = (this.green - this.blue) / delta;
        } else if ((double)Math.abs(this.green - max) < 1.0E-5) {
            h = 2.0f + (this.blue - this.red) / delta;
        } else if ((double)Math.abs(this.blue - max) < 1.0E-5) {
            h = 4.0f + (this.red - this.green) / delta;
        }
        h *= 60.0f;
        if (h < 0.0f) {
            h += 360.0f;
        }
        hsv[0] = h /= 360.0f;
        hsv[1] = s;
        hsv[2] = v;
        return hsv;
    }

    float findMin(float a, float b, float c) {
        if (a <= b && a <= c) {
            return a;
        }
        if (b <= a && b <= c) {
            return b;
        }
        if (c <= a && c <= b) {
            return c;
        }
        return c;
    }

    float findMax(float a, float b, float c) {
        if (a >= b && a >= c) {
            return a;
        }
        if (b > a && b > c) {
            return b;
        }
        return c;
    }

    float[] HSVtoRGB(float h, float s, float v) {
        float b;
        float g;
        float r;
        float[] rgb = new float[3];
        if (s == 0.0f) {
            float r2;
            float b2;
            float g2 = b2 = v;
            rgb[0] = r2 = b2;
            rgb[1] = g2;
            rgb[2] = b2;
            return rgb;
        }
        int i = (int)Math.floor(h *= 6.0f);
        float f = h - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        switch (i) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            default: {
                r = v;
                g = p;
                b = q;
            }
        }
        rgb[0] = r;
        rgb[1] = g;
        rgb[2] = b;
        return rgb;
    }

    Color getOriginalColor() {
        return new Color(this.originalRed, this.originalGreen, this.originalBlue, this.originalAlpha);
    }

    void revert() {
        this.red = this.originalRed;
        this.green = this.originalGreen;
        this.blue = this.originalBlue;
        this.alpha = this.originalAlpha;
        this.lut = this.originalLut;
        this.revInt = this.originalRevInt;
    }

    boolean isOriginalColor(Color color) {
        if (color == null) {
            return false;
        }
        Color c = this.getOriginalColor();
        return c.getRed() == color.getRed() && c.getGreen() == color.getGreen() && c.getBlue() == color.getBlue() && c.getAlpha() == color.getAlpha();
    }

    void setLUT(String lut, boolean reset) {
        this.lut = lut;
        if (reset) {
            this.originalLut = lut;
        }
    }

    void setLUT(String lut) {
        this.setLUT(lut, false);
    }

    String getLUT() {
        return this.lut;
    }

    String getOriginalLUT() {
        return this.originalLut;
    }

    void setReverseIntensity(boolean revInt, boolean reset) {
        this.revInt = revInt;
        if (reset) {
            this.originalRevInt = revInt;
        }
    }

    void setReverseIntensity(boolean revInt) {
        this.setReverseIntensity(revInt, false);
    }

    boolean getReverseIntensity() {
        return this.revInt;
    }

    boolean getOriginalReverseIntensity() {
        return this.originalRevInt;
    }

    boolean isOriginalLut(String lut) {
        if (lut == null) {
            lut = "";
        }
        if (this.originalLut == null) {
            this.originalLut = "";
        }
        return lut.equals(this.originalLut);
    }

    Collection<String> getAvailableLookupTables() {
        return this.availableLUTs;
    }
}

