/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang.StringUtils;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPicker;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourSwatchUI;
import org.openmicroscopy.shoola.util.ui.colourpicker.HSVColourWheelUI;
import org.openmicroscopy.shoola.util.ui.colourpicker.PaintPotUI;
import org.openmicroscopy.shoola.util.ui.colourpicker.RGBControl;

class TabbedPaneUI
extends JPanel
implements ActionListener,
ChangeListener,
DocumentListener {
    static final int TEXTBOX_COLUMN = 2;
    private static final String COLOURWHEELPANE = "Color Wheel Pane";
    private static final String SWATCHPANE = "Swatch Pane";
    private static final int PREVIEW = 0;
    private static final int CANCEL = 1;
    private static final int ACCEPT = 2;
    private static final int REVERT = 3;
    private JToolBar toolbar;
    private JPanel userActionPanel;
    private JToggleButton colourWheelButton;
    private JToggleButton colourSwatchButton;
    private JCheckBox revIntButton;
    private JButton acceptButton;
    private JButton previewButton;
    private JButton revertButton;
    private JButton cancelButton;
    private JTextField fieldDescription;
    private HSVColourWheelUI colourWheelPane;
    private ColourSwatchUI swatchPane;
    private CardLayout tabPaneLayout;
    private JPanel tabPanel;
    private PaintPotUI paintPotPane;
    private RGBControl control;
    private ColourPicker parent;
    private String originalDescription;
    private boolean preview;

    private void createToolbar() {
        this.toolbar = new JToolBar();
        IconManager icons = IconManager.getInstance();
        this.colourWheelButton = new JToggleButton(icons.getIcon(2));
        UIUtilities.unifiedButtonLookAndFeel(this.colourWheelButton);
        this.colourWheelButton.setBorderPainted(true);
        this.colourWheelButton.setToolTipText("Show HSV Color Wheel.");
        AbstractAction action = new AbstractAction("HSV Wheel Color Button"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabbedPaneUI.this.clearToggleButtons();
                TabbedPaneUI.this.pickWheelPane();
            }
        };
        this.colourWheelButton.addActionListener(action);
        this.colourSwatchButton = new JToggleButton(icons.getIcon(1));
        this.colourSwatchButton.setToolTipText("Show Color List.");
        UIUtilities.unifiedButtonLookAndFeel(this.colourSwatchButton);
        this.colourSwatchButton.setBorderPainted(true);
        action = new AbstractAction("Color Swatch Button"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabbedPaneUI.this.clearToggleButtons();
                TabbedPaneUI.this.pickSwatchPane();
            }
        };
        this.colourSwatchButton.addActionListener(action);
        this.revIntButton = new JCheckBox("Invert");
        this.revIntButton.setToolTipText("Invert this channel's intensity");
        this.revIntButton.setSelected(this.control.getReverseIntensity());
        this.revIntButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedPaneUI.this.control.setReverseIntensity(TabbedPaneUI.this.revIntButton.isSelected());
            }
        });
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.toolbar.setLayout(new BoxLayout(this.toolbar, 2));
        this.toolbar.add(this.colourSwatchButton);
        this.toolbar.add(this.colourWheelButton);
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add(this.revIntButton);
    }

    private void createActionbar() {
        this.userActionPanel = new JPanel();
        this.userActionPanel.setLayout(new FlowLayout());
        this.acceptButton = new JButton("Accept");
        this.acceptButton.setToolTipText("Accept the selected color.");
        this.acceptButton.setActionCommand("2");
        this.acceptButton.addActionListener(this);
        this.revertButton = new JButton("Revert");
        this.revertButton.setToolTipText("Revert to the original color.");
        this.revertButton.setActionCommand("3");
        this.revertButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Close the Color Picker.");
        this.cancelButton.setActionCommand("1");
        this.cancelButton.addActionListener(this);
        this.previewButton = new JButton("Preview");
        this.previewButton.setToolTipText("Preview the color change.");
        this.previewButton.setActionCommand("0");
        this.previewButton.addActionListener(this);
        this.previewButton.setVisible(false);
        this.userActionPanel.add(this.previewButton);
        this.userActionPanel.add(this.acceptButton);
        this.userActionPanel.add(this.revertButton);
        this.userActionPanel.add(this.cancelButton);
        this.setButtonsEnabled(false);
        this.parent.getRootPane().setDefaultButton(this.cancelButton);
    }

    private void createPanels() {
        this.colourWheelPane = new HSVColourWheelUI(this.control);
        this.swatchPane = new ColourSwatchUI(this.control);
        this.paintPotPane = new PaintPotUI(this.control.getColour(), this.control.getLUT(), this.control);
    }

    private void createUI(boolean field) {
        this.createToolbar();
        this.createActionbar();
        this.createPanels();
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        container.add((Component)this.toolbar, "Center");
        this.setLayout(new BoxLayout(this, 1));
        this.add(container);
        this.paintPotPane.setPreferredSize(new Dimension(260, 24));
        this.add(Box.createVerticalStrut(5));
        this.add(this.paintPotPane);
        this.add(Box.createVerticalStrut(5));
        this.tabPanel = new JPanel();
        this.tabPaneLayout = new CardLayout();
        this.tabPanel.setLayout(this.tabPaneLayout);
        this.tabPanel.add((Component)this.swatchPane, SWATCHPANE);
        this.tabPanel.add((Component)this.colourWheelPane, COLOURWHEELPANE);
        this.add(this.tabPanel);
        if (field) {
            this.add(new JSeparator());
            JLabel label = UIUtilities.setTextFont("Description: ");
            JPanel p = new JPanel();
            double[][] size = new double[][]{{-2.0, -1.0}, {-2.0}};
            p.setLayout(new TableLayout(size));
            p.add((Component)label, "0, 0");
            this.fieldDescription = new JTextField();
            p.add((Component)this.fieldDescription, "1, 0");
            this.add(p);
        }
        this.add(this.userActionPanel);
        if (this.control.isCustomColor()) {
            this.pickWheelPane();
        } else {
            this.pickSwatchPane();
        }
    }

    private void clearToggleButtons() {
        this.colourWheelButton.setSelected(false);
        this.colourSwatchButton.setSelected(false);
    }

    private void pickWheelPane() {
        this.colourWheelButton.setSelected(true);
        this.colourWheelPane.setActive(true);
        this.tabPaneLayout.show(this.tabPanel, COLOURWHEELPANE);
        this.swatchPane.setActive(false);
        this.colourWheelPane.findPuck();
        this.colourWheelPane.refresh();
        this.colourWheelPane.repaint();
    }

    private void pickSwatchPane() {
        this.tabPaneLayout.show(this.tabPanel, SWATCHPANE);
        this.colourSwatchButton.setSelected(true);
        this.swatchPane.setActive(true);
        this.colourWheelPane.setActive(false);
        this.doLayout();
        this.swatchPane.refresh();
    }

    TabbedPaneUI(ColourPicker parent, RGBControl control, boolean field) {
        if (parent == null) {
            throw new NullPointerException("No parent.");
        }
        if (control == null) {
            throw new NullPointerException("No control.");
        }
        this.parent = parent;
        this.control = control;
        this.createUI(field);
        this.control.addListener(this);
    }

    void setButtonsEnabled(boolean enabled) {
        this.acceptButton.setEnabled(enabled);
        this.revertButton.setEnabled(enabled);
        this.previewButton.setEnabled(enabled);
        if (enabled) {
            this.parent.getRootPane().setDefaultButton(this.acceptButton);
        } else {
            this.parent.getRootPane().setDefaultButton(this.cancelButton);
        }
    }

    void revertAction() {
        this.control.revert();
        this.swatchPane.revert();
        if (this.preview) {
            this.preview = false;
            this.parent.reset();
        }
    }

    String getDescription() {
        if (this.fieldDescription == null) {
            return null;
        }
        String text = this.fieldDescription.getText();
        if (StringUtils.isBlank((String)text)) {
            return null;
        }
        return text;
    }

    boolean getReverseIntensity() {
        return this.revIntButton.isSelected();
    }

    void setColorDescription(String description) {
        if (this.fieldDescription == null || description == null) {
            return;
        }
        this.originalDescription = description;
        this.fieldDescription.setText(description);
        this.fieldDescription.getDocument().addDocumentListener(this);
    }

    void setPreviewVisible(boolean visible) {
        this.previewButton.setVisible(visible);
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        if (this.colourWheelPane != null && this.colourWheelPane.isVisible()) {
            this.colourWheelPane.refresh();
        }
        if (this.swatchPane != null && this.swatchPane.isVisible()) {
            this.swatchPane.refresh();
        }
        if (this.fieldDescription == null) {
            this.setButtonsEnabled(!this.control.isOriginalColour() || !this.control.isOriginalLut() || !this.control.isOriginalRevInt());
        } else {
            String text = this.fieldDescription.getText();
            this.setButtonsEnabled(!text.equals(this.originalDescription) || !this.control.isOriginalColour() || !this.control.isOriginalLut() || !this.control.isOriginalRevInt());
        }
        this.revIntButton.setSelected(this.control.getReverseIntensity());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.fieldDescription == null) {
            return;
        }
        String text = this.fieldDescription.getText();
        this.setButtonsEnabled(!text.equals(this.originalDescription) || !this.control.isOriginalColour() || !this.control.isOriginalLut());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.fieldDescription == null) {
            return;
        }
        String text = this.fieldDescription.getText();
        this.setButtonsEnabled(!text.equals(this.originalDescription) || !this.control.isOriginalColour() || !this.control.isOriginalLut());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int v = Integer.parseInt(e.getActionCommand());
        switch (v) {
            case 1: {
                this.parent.cancel();
                break;
            }
            case 3: {
                this.revertAction();
                break;
            }
            case 2: {
                this.parent.accept();
                break;
            }
            case 0: {
                this.preview = true;
                this.parent.preview();
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

