/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.filechooser;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.RegExFactory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileSaverDialog;
import org.openmicroscopy.shoola.util.ui.filechooser.FileSaverUI;

public class FileChooser
extends JDialog {
    public static final String DOWNLOAD_TEXT = "Download";
    public static final String DOWNLOAD_DESCRIPTION = "Select where to download the file(s).";
    public static final String APPROVE_SELECTION_PROPERTY = "approveSelection";
    public static final String CANCEL_SELECTION_PROPERTY = "cancelSelection";
    public static final String LOCATION_PROPERTY = "location";
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    public static final int FOLDER_CHOOSER = 2;
    public static final int IMPORT = 3;
    public static final int LEFT = 100;
    public static final int CENTER = 101;
    public static final int RIGHT = 102;
    private int option;
    private FileSaverUI uiDelegate;
    private int dialogType;
    private String title;
    private String message;
    private List<FileFilter> filters;
    private List<String> paths;
    private String folderPath;
    private boolean checkOverride;
    private boolean override;

    private void setProperties() {
        this.setTitle(this.title);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FileChooser.this.cancelSelection();
            }

            @Override
            public void windowOpened(WindowEvent e) {
                FileChooser.this.uiDelegate.requestFocusOnName();
            }
        });
    }

    private void checkType(int v) {
        switch (v) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        throw new IllegalArgumentException("Type not supported");
    }

    public FileChooser(JFrame owner, int dialogType, String title, String message, List<FileFilter> filters, boolean accept, boolean checkOverride) {
        super(owner);
        this.checkType(dialogType);
        this.dialogType = dialogType;
        this.title = title;
        this.message = message;
        this.filters = filters;
        this.checkOverride = checkOverride;
        this.setProperties();
        this.folderPath = null;
        this.uiDelegate = new FileSaverUI(this, accept);
        this.pack();
    }

    public FileChooser(JFrame owner, int dialogType, String title, String message, List<FileFilter> filters, boolean accept) {
        this(owner, dialogType, title, message, filters, accept, false);
    }

    public FileChooser(JFrame owner, int dialogType, String title, String message, List<FileFilter> filters) {
        this(owner, dialogType, title, message, filters, false, false);
    }

    public FileChooser(JFrame owner, int dialogType, String title, String message) {
        this(owner, dialogType, title, message, null, false);
    }

    String getNote() {
        return this.message;
    }

    List<FileFilter> getFilters() {
        return this.filters;
    }

    String getExtendedName(String name, String format) {
        String extension = "." + format;
        Pattern pattern = RegExFactory.createPattern(extension);
        String n = RegExFactory.find(pattern, name) ? name : (RegExFactory.find(pattern = RegExFactory.createCaseInsensitivePattern(extension), name) ? name : name + "." + format);
        return n;
    }

    void cancelSelection() {
        this.firePropertyChange(CANCEL_SELECTION_PROPERTY, (Object)false, (Object)true);
        this.option = 1;
        this.setVisible(false);
        this.dispose();
    }

    void acceptSelection() {
        FileFilter filter;
        File f;
        String extension;
        this.option = 0;
        this.override = false;
        if (this.getChooserType() == 2) {
            File f2 = this.uiDelegate.getCurrentDirectory();
            if (f2 != null) {
                String path;
                if (!CollectionUtils.isEmpty(this.paths) && this.checkOverride) {
                    File[] entries = f2.listFiles();
                    boolean exist = false;
                    for (int i = 0; i < entries.length; ++i) {
                        if (!this.paths.contains(entries[i].getName())) continue;
                        exist = true;
                    }
                    if (exist) {
                        MessageBox msg = new MessageBox(this, "Overwrite existing files.", "Do you wish to overwrite the existing files?");
                        int option = msg.centerMsgBox();
                        boolean bl = this.override = option == 1;
                    }
                }
                if (!(path = f2.getAbsolutePath()).endsWith(File.separator)) {
                    path = path + File.separator;
                }
                this.firePropertyChange(APPROVE_SELECTION_PROPERTY, null, path);
                this.setVisible(false);
                this.dispose();
            }
            return;
        }
        File[] files = this.uiDelegate.isMultisSelectionEnabled() ? this.getSelectedFiles() : new File[]{this.getSelectedFile()};
        if (this.uiDelegate.isSetDefaultFolder() && this.getChooserType() != 2) {
            UIUtilities.setDefaultFolder(this.uiDelegate.getCurrentDirectory().toString());
        }
        if (CommonsLangUtils.isBlank(extension = FilenameUtils.getExtension((String)(f = this.getSelectedFile()).getName())) && (filter = this.getSelectedFilter()) instanceof CustomizedFileFilter) {
            extension = ((CustomizedFileFilter)filter).getExtension();
            files[0] = f = new File(f.getAbsolutePath() + "." + extension);
        }
        if (this.getChooserType() != 2 && f.exists() && this.checkOverride) {
            MessageBox msg = new MessageBox(this, "Overwrite existing file.", "Do you wish to overwrite the existing file?");
            int option = msg.centerMsgBox();
            if (option == 0) {
                return;
            }
            String path = f.getAbsolutePath();
            f.delete();
            files[0] = new File(path);
        }
        this.firePropertyChange(APPROVE_SELECTION_PROPERTY, (Object)false, files);
        this.setVisible(false);
        this.dispose();
    }

    void setFolderPath(String path) {
        if (path == null) {
            return;
        }
        this.folderPath = path;
        this.firePropertyChange(LOCATION_PROPERTY, null, path + File.separatorChar);
        this.setVisible(false);
        this.dispose();
    }

    void setSelection() {
        IconManager im = IconManager.getInstance();
        FileSaverDialog d = new FileSaverDialog(this, im.getIcon(52));
        UIUtilities.centerAndShow(d);
    }

    public File getFolderPath() {
        if (this.folderPath != null) {
            return new File(this.folderPath);
        }
        return null;
    }

    public int getChooserType() {
        return this.dialogType;
    }

    public void setSelectedFile(String name) {
        if (CommonsLangUtils.isBlank(name)) {
            throw new IllegalArgumentException("File name not valid.");
        }
        String s = FilenameUtils.getBaseName((String)name);
        if (CommonsLangUtils.isBlank(s)) {
            s = name;
        }
        this.uiDelegate.setSelectedFile(new File(s));
    }

    public void setSelectedFileFull(String name) {
        if (CommonsLangUtils.isBlank(name)) {
            return;
        }
        this.uiDelegate.setSelectedFile(new File(name));
    }

    public void setSelectedFile(File name) {
        if (name == null) {
            return;
        }
        this.uiDelegate.setSelectedFile(name);
    }

    public void setCurrentDirectory(String dir) {
        if (CommonsLangUtils.isBlank(dir)) {
            throw new IllegalArgumentException("Folder name not valid.");
        }
        this.uiDelegate.setCurrentDirectory(new File(dir));
    }

    public void setCurrentDirectory(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Folder cannot be null.");
        }
        this.uiDelegate.setCurrentDirectory(dir);
    }

    public File getSelectedFile() {
        return this.uiDelegate.getSelectedFile();
    }

    public File[] getSelectedFiles() {
        return this.uiDelegate.getSelectedFiles();
    }

    public File getFormattedSelectedFile() {
        return this.uiDelegate.getFormattedSelectedFile();
    }

    public FileFilter getSelectedFilter() {
        return this.uiDelegate.getSelectedFilter();
    }

    public int showDialog() {
        UIUtilities.setLocationRelativeToAndShow(this.getParent(), this);
        return this.option;
    }

    public int centerDialog() {
        UIUtilities.centerAndShow(this);
        return this.option;
    }

    public void setApproveButtonText(String text) {
        if (CommonsLangUtils.isBlank(text)) {
            return;
        }
        this.uiDelegate.setApproveButtonText(text);
    }

    public void setApproveButtonToolTipText(String text) {
        if (CommonsLangUtils.isBlank(text)) {
            return;
        }
        this.uiDelegate.setApproveButtonToolTipText(text);
    }

    public void addControlButton(JButton button, int location) {
        if (button == null) {
            throw new IllegalArgumentException("Button cannot be null.");
        }
        switch (location) {
            case 100: 
            case 101: 
            case 102: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Location not supported.");
            }
        }
        this.uiDelegate.addControlButton(button, location);
    }

    public void addComponentToControls(JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("The component cannot be null.");
        }
        this.uiDelegate.addComponentToControls(component);
    }

    public void setTitleIcon(Icon icon) {
        if (icon == null) {
            return;
        }
        this.uiDelegate.setTitleIcon(icon);
    }

    public void setMultiSelectionEnabled(boolean enabled) {
        this.uiDelegate.setMultiSelectionEnabled(enabled);
    }

    public void setCheckOverride(boolean checkOverride) {
        this.checkOverride = checkOverride;
    }

    public void setSelectedFiles(List<String> paths) {
        this.paths = paths;
    }

    public boolean isOverride() {
        return this.override;
    }
}

