/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.graphutils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.apache.commons.collections.CollectionUtils;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;

public abstract class ChartObject {
    public static final String X_AXIS = "X-Axis";
    public static final String Y_AXIS = "Y-Axis";
    public static final int SAVE_AS_PNG = 0;
    public static final int SAVE_AS_JPEG = 1;
    static final int WIDTH = 500;
    static final int HEIGHT = 300;
    protected JFreeChart chart;
    protected String title;
    protected List<String> legends;
    protected List<Color> colours;
    protected NumberAxis rangeAxis;
    protected NumberAxis domainAxis;
    protected Image backgroundImage;

    protected void init() {
        this.legends = new ArrayList<String>();
        this.colours = new ArrayList<Color>();
    }

    public ChartObject(String title) {
        this.title = title;
        this.init();
    }

    public void setDefaultAxis() {
        this.setXAxisName(X_AXIS);
        this.setYAxisName(Y_AXIS);
    }

    public void setYAxisName(String axisName) {
        if (axisName == null || axisName.trim().length() == 0) {
            axisName = Y_AXIS;
        }
        this.rangeAxis = new NumberAxis(axisName);
    }

    public void setYAxisRange(double axisMinRange, double axisMaxRange) {
        if (this.rangeAxis == null) {
            this.setYAxisName(Y_AXIS);
        }
        this.rangeAxis.setRange(axisMinRange, axisMaxRange);
        this.rangeAxis.setAutoRange(false);
    }

    public void setXAxisRange(double axisMinRange, double axisMaxRange) {
        if (this.domainAxis == null) {
            this.setXAxisName(X_AXIS);
        }
        this.domainAxis.setRange(axisMinRange, axisMaxRange);
        this.domainAxis.setAutoRange(false);
    }

    public void setXAxisName(String axisName) {
        if (axisName == null || axisName.trim().length() == 0) {
            axisName = X_AXIS;
        }
        this.domainAxis = new NumberAxis(axisName);
    }

    public void saveAs(File file, int savingType) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("No file specified");
        }
        try {
            switch (savingType) {
                case 0: {
                    ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)this.chart, (int)500, (int)300);
                    break;
                }
                case 1: {
                    ChartUtilities.saveChartAsJPEG((File)file, (JFreeChart)this.chart, (int)500, (int)300);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Unable to save the file.", e);
        }
    }

    public JPanel getChart(Image image, boolean removeLegend, List<AbstractAction> actions) {
        this.backgroundImage = image;
        this.createChart();
        if (removeLegend) {
            this.chart.removeLegend();
        }
        JPanel graphPanel = new JPanel();
        if (this.chart == null) {
            return graphPanel;
        }
        graphPanel.setLayout(new BorderLayout());
        ChartPanel p = new ChartPanel(this.chart, true, false, true, true, true);
        if (!CollectionUtils.isEmpty(actions)) {
            p.getPopupMenu().add(new JSeparator());
        }
        for (AbstractAction action : actions) {
            JMenuItem exportMenu = new JMenuItem(action);
            p.getPopupMenu().add(exportMenu);
        }
        graphPanel.add((Component)p, "Center");
        return graphPanel;
    }

    public JPanel getChart(boolean removeLegend, List<AbstractAction> actions) {
        return this.getChart(null, removeLegend, actions);
    }

    public JPanel getChart() {
        return this.getChart(null, false, Collections.emptyList());
    }

    public JPanel getChart(List<AbstractAction> actions) {
        return this.getChart(null, false, actions);
    }

    abstract void createChart();
}

