/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.lens;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.enums.UnitsLength;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class StatusPanel
extends JPanel {
    static final String LENS_X = "X : ";
    static final String LENS_Y = "Y : ";
    static final String LENS_W = "W : ";
    static final String LENS_H = "H : ";
    static final String LENS_MAGNIFICATION = "x";
    private JLabel lensPosition;
    private JLabel lensSize;
    private JLabel lensZoom;
    private Length pixelSizeX = new LengthI(1.0, UnitsLength.PIXEL);
    private Length pixelSizeY = new LengthI(1.0, UnitsLength.PIXEL);
    private boolean displayInPixels = true;

    StatusPanel() {
        this.lensPosition = new JLabel("X :  000 Y :  000");
        this.lensSize = new JLabel("W :  000 H :  000");
        this.lensZoom = new JLabel("x00");
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.lensPosition);
        Dimension minSize = new Dimension(15, 1);
        Dimension prefSize = new Dimension(15, 1);
        Dimension maxSize = new Dimension(15, 1);
        this.add(new Box.Filler(minSize, prefSize, maxSize));
        this.add(this.lensSize);
        this.add(new Box.Filler(minSize, prefSize, maxSize));
        this.add(this.lensZoom);
    }

    void setDisplayInPixels(boolean b) {
        this.displayInPixels = b;
    }

    void setLensXY(int x, int y) {
        if (this.displayInPixels) {
            this.lensPosition.setText(LENS_X + x + " " + LENS_Y + y);
        } else {
            this.lensPosition.setText(LENS_X + UIUtilities.twoDecimalPlaces((double)x * this.pixelSizeX.getValue()) + this.pixelSizeX.getSymbol() + " " + LENS_Y + UIUtilities.twoDecimalPlaces((double)y * this.pixelSizeY.getValue()) + this.pixelSizeY.getSymbol());
        }
    }

    void setLensWidthHeight(int w, int h) {
        if (this.displayInPixels) {
            this.lensSize.setText(LENS_W + w + " " + LENS_H + h);
        } else {
            this.lensSize.setText(LENS_W + UIUtilities.twoDecimalPlaces((double)w * this.pixelSizeX.getValue()) + this.pixelSizeX.getSymbol() + " " + LENS_H + UIUtilities.twoDecimalPlaces((double)h * this.pixelSizeY.getValue()) + this.pixelSizeY.getSymbol());
        }
    }

    void setLensZoomFactor(float zoomFactor) {
        this.lensZoom.setText(LENS_MAGNIFICATION + zoomFactor);
    }

    public void setXYPixelSizes(Length x, Length y) {
        this.pixelSizeX = x;
        this.pixelSizeY = y;
    }
}

