/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.login;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.StringComparator;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.login.LoginCredentials;
import org.openmicroscopy.shoola.util.ui.login.ServerDialog;
import org.openmicroscopy.shoola.util.ui.login.ServerEditor;

public class ScreenLogin
extends JFrame
implements ActionListener,
DocumentListener,
PropertyChangeListener {
    public static final String TO_FRONT_PROPERTY = "toFront";
    public static final String LOGIN_PROPERTY = "login";
    public static final String QUIT_PROPERTY = "quit";
    public static final int USERNAME_FIELD = 0;
    public static final int PASSWORD_FIELD = 1;
    public static final String DEFAULT_SERVER = "Add a new server ->";
    static final Color TEXT_COLOR = new Color(110, 102, 96);
    static final Color FOOT_NOTE_COLOR = new Color(156, 165, 174);
    static final Dimension DEFAULT_SIZE = new Dimension(551, 113);
    private static final Color FOREGROUND_COLOR = Color.DARK_GRAY;
    private static final String OMERO_USER = "omeroUser";
    private static final String OMERO_CONNECTION_SPEED = "omeroConnectionSpeed";
    private static final String OMERO_USER_GROUP = "omeroUserGroup";
    private static final String OMERO_TRANSFER_ENCRYPTED = "omeroTransferEncrypted";
    private static final int TEXT_INDENT = 15;
    private static final int VERSION_FONT_STYLE = 1;
    private static final String USER_TEXT = "Username: ";
    private static final String PASSWORD_TEXT = "Password: ";
    private static final int TEXT_COLUMN = 12;
    private static final int MAX_CHAR = 50;
    private static JTextField user;
    private JPasswordField pass;
    private JButton configButton;
    private JButton login;
    private JButton cancel;
    private String serverName;
    private static JTextPane serverText;
    private JPanel serverTextPane;
    private JLabel connectionSpeedText;
    private JTextPane versionInfo;
    private ServerEditor editor;
    private int speedIndex;
    private int selectedPort;
    private boolean connectionSpeed;
    private Color defaultForeground;
    private JComboBox groupsBox;
    private JTextPane pleaseLogIn;
    private Map<Long, String> groups;
    private String originalName;
    private String originalServerName;
    private List<JComponent> ref;
    private JPanel mainPanel;
    private String[] groupValues;
    private JButton encryptedButton;
    private boolean encrypted;
    private Map<Integer, String> groupNames;
    private JLayeredPane layers;
    private JLabel currentTask;
    private JProgressBar progressBar;
    private boolean loginAttempt;
    private ActionListener encryptionListener;
    private boolean hostConfigurable;
    private String configureServerName;
    private List<JComponent> components;

    private void quit() {
        String usr = user.getText().trim();
        String server = serverText.getText();
        if (usr == null) {
            usr = "";
        }
        if (server == null) {
            server = "";
        }
        this.firePropertyChange(QUIT_PROPERTY, (Object)false, (Object)true);
    }

    private void login() {
        LoginCredentials lc;
        this.firePropertyChange(TO_FRONT_PROPERTY, (Object)false, (Object)true);
        this.requestFocusOnField();
        StringBuffer buf = new StringBuffer();
        buf.append(this.pass.getPassword());
        String usr = user.getText();
        String psw = buf.toString();
        String s = serverText.getText();
        if (CommonsLangUtils.isBlank(usr) || CommonsLangUtils.isBlank(s) || s.trim().equals(DEFAULT_SERVER)) {
            this.requestFocusOnField();
            return;
        }
        if (usr != null) {
            usr = usr.trim();
        }
        if (s != null) {
            s = s.trim();
        }
        this.setControlsEnabled(false);
        if (this.groupsBox == null) {
            lc = new LoginCredentials(usr, psw, s, this.speedIndex, this.selectedPort, this.encrypted);
        } else {
            long id = -1L;
            if (this.hasGroupOption() && this.groupsBox.isVisible()) {
                id = this.getGroupId(this.groupNames.get(this.groupsBox.getSelectedIndex()));
            }
            lc = new LoginCredentials(usr, psw, s, this.speedIndex, this.selectedPort, id, this.encrypted);
        }
        this.setUserName(usr);
        this.setEncrypted();
        this.setControlsEnabled(false);
        this.loginAttempt = true;
        this.login.setEnabled(false);
        this.firePropertyChange(LOGIN_PROPERTY, null, lc);
    }

    private Long getGroupId(String value) {
        for (Map.Entry<Long, String> entry : this.groups.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return -1L;
    }

    private boolean hasGroupOption() {
        String usr = user.getText().trim();
        String s = serverText.getText().trim();
        return usr.equals(this.originalName) && s.equals(this.originalServerName);
    }

    private void config() {
        String s = serverText.getText().trim();
        ServerDialog d = this.connectionSpeed ? new ServerDialog(this, this.editor, s, this.speedIndex) : new ServerDialog(this, this.editor, s);
        if (this.editor.getRowCount() == 0 && this.configureServerName != null) {
            this.editor.addRow(this.configureServerName);
        }
        d.addPropertyChangeListener(this);
        UIUtilities.centerAndShow(d);
    }

    private void encrypt() {
        if (!this.encryptedButton.isEnabled()) {
            return;
        }
        this.encrypted = !this.encrypted;
        IconManager icons = IconManager.getInstance();
        if (this.encrypted) {
            this.encryptedButton.setIcon(icons.getIcon(138));
        } else {
            this.encryptedButton.setIcon(icons.getIcon(139));
        }
    }

    private void initListeners() {
        user.getDocument().addDocumentListener(this);
        this.pass.getDocument().addDocumentListener(this);
        this.login.addActionListener(this);
        user.addActionListener(this);
        this.pass.addActionListener(this);
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenLogin.this.quit();
            }
        });
        this.configButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenLogin.this.config();
            }
        });
        this.encryptionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenLogin.this.encrypt();
            }
        };
        this.encryptedButton.addActionListener(this.encryptionListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ScreenLogin.this.requestFocusOnField();
            }
        });
        user.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ScreenLogin.this.firePropertyChange(ScreenLogin.TO_FRONT_PROPERTY, false, true);
                user.requestFocus();
            }
        });
        this.pass.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ScreenLogin.this.firePropertyChange(ScreenLogin.TO_FRONT_PROPERTY, false, true);
            }
        });
    }

    private void setButtonDefault(JButton button) {
        button.setRolloverEnabled(false);
        button.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void initializeGroups() {
        this.groups = this.getGroups();
        if (this.groups != null && this.groups.size() > 1) {
            this.groupNames = new HashMap<Integer, String>();
            this.groupValues = new String[this.groups.size()];
            Iterator<Map.Entry<Long, String>> i = this.groups.entrySet().iterator();
            int index = 0;
            while (i.hasNext()) {
                Map.Entry<Long, String> entry = i.next();
                this.groupValues[index] = entry.getValue();
                ++index;
            }
            String selectedGroup = this.groupValues[this.groupValues.length - 1];
            Arrays.sort(this.groupValues, new StringComparator());
            String[] sorted = new String[this.groupValues.length];
            for (int j = 0; j < this.groupValues.length; ++j) {
                String v;
                String value = v = this.groupValues[j];
                if (v.length() > 50) {
                    value = v.substring(0, 50) + "...";
                }
                this.groupNames.put(j, v);
                sorted[j] = value;
                if (!selectedGroup.equals(v)) continue;
                selectedGroup = value;
            }
            this.groupsBox = new JComboBox<String>(sorted);
            this.groupsBox.setSelectedItem(selectedGroup);
        } else {
            if (this.groupNames != null) {
                this.groupNames.clear();
            }
            this.groupsBox = null;
        }
    }

    private void initialize(String userName, String hostName) {
        Iterator<String> i;
        int n;
        this.components = new ArrayList<JComponent>();
        this.currentTask = new JLabel();
        Font newFont = this.currentTask.getFont().deriveFont(8);
        this.currentTask.setFont(newFont);
        this.currentTask.setForeground(TEXT_COLOR);
        this.progressBar = new JProgressBar();
        this.progressBar.setVisible(false);
        this.progressBar.setStringPainted(false);
        this.progressBar.setFont(newFont);
        this.originalName = userName;
        user = new JTextField();
        user.setName("username field");
        user.setText(userName);
        user.setToolTipText("Enter your username.");
        user.setColumns(12);
        this.pass = new JPasswordField();
        this.pass.setName("password field");
        this.pass.setToolTipText("Enter your password.");
        this.pass.setColumns(12);
        Map<String, String> servers = this.editor.getServers();
        if (CommonsLangUtils.isNotBlank(hostName)) {
            this.serverName = hostName;
            if (servers != null && servers.size() > 0) {
                n = servers.size() - 1;
                i = servers.keySet().iterator();
                int k = 0;
                while (i.hasNext()) {
                    String value;
                    this.serverName = i.next();
                    if (k == n && (value = servers.get(this.serverName)) != null) {
                        try {
                            this.selectedPort = Integer.parseInt(value);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++k;
                }
            } else {
                this.editor.removeLastRow();
                this.editor.addRow(hostName);
            }
        } else if (servers == null || servers.size() == 0) {
            this.serverName = hostName;
        } else {
            n = servers.size() - 1;
            i = servers.keySet().iterator();
            int k = 0;
            while (i.hasNext()) {
                String value;
                this.serverName = i.next();
                if (k == n && (value = servers.get(this.serverName)) != null) {
                    try {
                        this.selectedPort = Integer.parseInt(value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++k;
            }
        }
        if (this.serverName.length() == 0) {
            this.serverName = DEFAULT_SERVER;
        }
        if (!DEFAULT_SERVER.equals(this.serverName)) {
            this.originalServerName = this.serverName;
        }
        this.connectionSpeedText = new JLabel(this.getConnectionSpeed());
        this.connectionSpeedText.setForeground(TEXT_COLOR);
        this.connectionSpeedText.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        serverText = UIUtilities.buildTextPane(this.serverName, TEXT_COLOR);
        serverText.setName("server name text pane");
        this.serverTextPane = UIUtilities.buildComponentPanelRight(serverText, false);
        this.serverTextPane.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.initializeGroups();
        this.ref = new ArrayList<JComponent>();
        this.login = new JButton("Login");
        this.login.setName("login button");
        this.defaultForeground = this.login.getForeground();
        this.login.setMnemonic('L');
        this.login.setToolTipText("Login");
        this.setButtonDefault(this.login);
        this.login.setEnabled(false);
        UIUtilities.opacityCheck(this.login);
        this.cancel = new JButton("Quit");
        this.cancel.setMnemonic('Q');
        this.cancel.setToolTipText("Cancel Login.");
        this.setButtonDefault(this.cancel);
        UIUtilities.opacityCheck(this.cancel);
        this.configButton = new JButton();
        this.configButton.setName("config server button");
        this.configButton.setMnemonic('X');
        this.configButton.setToolTipText("Enter the server's address.");
        this.configButton.setBorderPainted(false);
        this.configButton.setBorder(null);
        this.configButton.setFocusPainted(false);
        this.configButton.setContentAreaFilled(false);
        IconManager icons = IconManager.getInstance();
        this.configButton.setIcon(icons.getIcon(25));
        this.encrypted = !this.isEncrypted();
        this.encryptedButton = new JButton();
        ArrayList<String> tips = new ArrayList<String>();
        tips.add("The connection to the server is always encrypted.");
        tips.add("If selected, the data transfer (e.g. annotations, images) will also be encrypted.");
        tips.add("But the transfer will be much slower.");
        this.encryptedButton.setToolTipText(UIUtilities.formatToolTipText(tips));
        this.encryptedButton.setBorderPainted(false);
        this.encryptedButton.setBorder(null);
        this.encryptedButton.setFocusPainted(false);
        this.encryptedButton.setContentAreaFilled(false);
        if (this.encrypted) {
            this.encryptedButton.setIcon(icons.getIcon(138));
        } else {
            this.encryptedButton.setIcon(icons.getIcon(139));
        }
        this.getRootPane().setDefaultButton(this.login);
        this.enableControls();
    }

    private void layout(boolean group) {
        if (this.mainPanel == null) {
            return;
        }
        if (this.ref == null) {
            return;
        }
        Iterator<JComponent> i = this.ref.iterator();
        boolean visible = false;
        if (group && this.groups != null && this.groupsBox != null) {
            visible = true;
        }
        while (i.hasNext()) {
            i.next().setVisible(visible);
        }
        this.mainPanel.validate();
        this.mainPanel.repaint();
    }

    private JPanel buildLogin() {
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.serverTextPane);
        p.add(this.connectionSpeedText);
        JToolBar bar = new JToolBar();
        bar.setOpaque(false);
        bar.setBorder(null);
        bar.setFloatable(false);
        if (UIUtilities.isWindowsOS()) {
            bar.add(Box.createHorizontalStrut(5));
            bar.add(this.encryptedButton);
            bar.add(Box.createHorizontalStrut(5));
            bar.add(this.configButton);
        } else {
            bar.add(this.encryptedButton);
            bar.add(this.configButton);
        }
        JPanel row = new JPanel();
        row.setOpaque(false);
        row.setLayout(new FlowLayout(1, 0, 0));
        row.add(p);
        row.add(bar);
        this.mainPanel.add(row);
        this.components.add(row);
        JPanel group = new JPanel();
        group.setOpaque(false);
        group.setLayout(new BoxLayout(group, 1));
        JTextPane l = UIUtilities.buildTextPane(USER_TEXT, TEXT_COLOR);
        row = new JPanel();
        row.setOpaque(false);
        row.setLayout(new FlowLayout(1, 0, 0));
        row.add(l);
        row.add(user);
        group.add(row);
        l = UIUtilities.buildTextPane(" Password: ", TEXT_COLOR);
        row = new JPanel();
        row.setOpaque(false);
        row.setLayout(new FlowLayout(1, 0, 0));
        row.add(l);
        row.add(this.pass);
        group.add(row);
        this.mainPanel.add(group);
        this.components.add(group);
        JPanel controls = new JPanel();
        controls.setOpaque(false);
        controls.add(Box.createHorizontalGlue());
        controls.add(this.login);
        controls.add(this.cancel);
        p = UIUtilities.buildComponentPanelCenter(controls, 0, 0, false);
        this.mainPanel.add(p);
        this.components.add(p);
        return this.mainPanel;
    }

    private void buildGUI(Icon logo, String version, boolean serverAvailable) {
        JLabel splash = new JLabel(logo);
        this.layers = new JLayeredPane();
        this.layers.add((Component)splash, (Object)0);
        this.getContentPane().add(this.layers);
        int width = logo.getIconWidth();
        int height = logo.getIconHeight();
        this.layers.setBounds(0, 0, width, height);
        splash.setBounds(0, 0, width, height);
        int h = this.progressBar.getFontMetrics(this.progressBar.getFont()).getHeight();
        int top = 120;
        int bottom = 100;
        this.currentTask.setBounds(15, top, width - 30, h);
        this.progressBar.setBounds(15, top += 20, width - 30, h);
        this.addToLayer(this.currentTask);
        this.addToLayer(this.progressBar);
        this.mainPanel = new JPanel();
        this.mainPanel.setOpaque(false);
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.versionInfo = UIUtilities.buildTextPane(version, FOOT_NOTE_COLOR);
        Font f = this.versionInfo.getFont();
        this.versionInfo.setFont(f.deriveFont(1, f.getSize() - 4));
        this.versionInfo.setOpaque(false);
        int y = height - bottom - 10;
        y = top + 2 * h;
        this.buildLogin();
        this.displayComponents(serverAvailable);
        this.mainPanel.add(UIUtilities.buildComponentPanelCenter(this.versionInfo, 0, 0, false));
        this.mainPanel.setBounds(0, y, width, height - top - bottom);
        this.addToLayer(this.mainPanel);
    }

    private void displayComponents(boolean visible) {
        Iterator<JComponent> i = this.components.iterator();
        while (i.hasNext()) {
            i.next().setVisible(visible);
        }
        this.repaint();
    }

    private String getServerName() {
        String s = serverText.getText();
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    private String getConnectionSpeed() {
        switch (this.speedIndex) {
            case 0: {
                return " [High]";
            }
            case 1: {
                return " [Medium]";
            }
            case 2: {
                return " [Low]";
            }
        }
        return null;
    }

    private void setNewServer(String s) {
        if (CommonsLangUtils.isBlank(s)) {
            s = this.configureServerName != null ? this.configureServerName : DEFAULT_SERVER;
        }
        String[] values = s.split(":", 0);
        s = values[0];
        if (values.length == 2) {
            try {
                this.selectedPort = Integer.parseInt(values[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        serverText.setText(s);
        this.serverTextPane.validate();
        this.serverTextPane.repaint();
        this.initializeGroups();
        this.layout(this.groupsBox != null);
        this.enableControls();
    }

    private void enableControls() {
        boolean enabled = true;
        String s = serverText.getText();
        char[] name = this.pass.getPassword();
        String usr = user.getText().trim();
        if (CommonsLangUtils.isBlank(s) || CommonsLangUtils.isBlank(usr)) {
            enabled = false;
        } else if (DEFAULT_SERVER.equals(s = s.trim())) {
            enabled = false;
        }
        this.login.setEnabled(enabled);
        if (enabled) {
            ActionListener[] listeners = this.login.getActionListeners();
            if (listeners != null) {
                boolean set = false;
                for (int i = 0; i < listeners.length; ++i) {
                    if (listeners[i] != this) continue;
                    set = true;
                    break;
                }
                if (!set) {
                    this.login.addActionListener(this);
                }
            }
            this.login.setForeground(this.defaultForeground);
        } else {
            this.login.setForeground(FOREGROUND_COLOR);
        }
        this.layout(this.hasGroupOption());
    }

    private void setConnectionSpeed(int speed) {
        this.speedIndex = speed;
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        prefs.put(OMERO_CONNECTION_SPEED, "" + this.speedIndex);
    }

    private int retrieveConnectionSpeed() {
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        String s = prefs.get(OMERO_CONNECTION_SPEED, null);
        if (s == null || s.trim().length() == 0) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public void setUserName(String name) {
        if (name == null) {
            return;
        }
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        prefs.put(OMERO_USER, name);
    }

    private String getUserName() {
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        return prefs.get(OMERO_USER, null);
    }

    private boolean isEncrypted() {
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        String value = prefs.get(OMERO_TRANSFER_ENCRYPTED, null);
        return "true".equals(value);
    }

    private void setEncrypted() {
        String value = "false";
        if (this.encrypted) {
            value = "true";
        }
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        prefs.put(OMERO_TRANSFER_ENCRYPTED, value);
    }

    private Map<Long, String> getGroups() {
        LinkedHashMap<Long, String> groups = new LinkedHashMap<Long, String>();
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        String list = prefs.get(OMERO_USER_GROUP, null);
        if (list == null || list.length() == 0) {
            return groups;
        }
        String[] l = list.split(",", 0);
        if (l == null) {
            return groups;
        }
        String selectedName = user.getText();
        String selectedServer = serverText.getText();
        for (int index = 0; index < l.length; ++index) {
            long id;
            String name;
            String group = l[index].trim();
            if (group.length() <= 0) continue;
            String[] values = group.split(":", 0);
            if (values.length == 2) {
                name = values[1];
                try {
                    id = Long.parseLong(values[0]);
                    groups.put(id, name);
                }
                catch (Exception exception) {}
                continue;
            }
            if (values.length != 4) continue;
            String userName = values[0];
            String serverName = values[1];
            name = values[3];
            if (!userName.equals(selectedName) || !serverName.equals(selectedServer)) continue;
            try {
                id = Long.parseLong(values[2]);
                groups.put(id, name);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return groups;
    }

    private void setProperties(Image frameIcon) {
        this.setIconImage(frameIcon);
        this.setDefaultCloseOperation(3);
        this.setResizable(true);
        this.setUndecorated(true);
        this.toFront();
    }

    public ScreenLogin(String title, Icon logo, Image frameIcon, String version, String defaultPort, String hostName, boolean serverAvailable) {
        super(title);
        this.setName("login window");
        this.selectedPort = -1;
        Dimension d = logo != null ? new Dimension(logo.getIconWidth(), logo.getIconHeight()) : DEFAULT_SIZE;
        this.setSize(d);
        this.setPreferredSize(d);
        this.editor = new ServerEditor(defaultPort);
        this.editor.addPropertyChangeListener("remove", this);
        this.speedIndex = this.retrieveConnectionSpeed();
        this.initialize(this.getUserName(), hostName);
        this.initListeners();
        this.buildGUI(logo, version, serverAvailable);
        this.encrypt();
        this.setProperties(frameIcon);
        this.showConnectionSpeed(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ScreenLogin.this.firePropertyChange(ScreenLogin.TO_FRONT_PROPERTY, false, true);
                ScreenLogin.this.requestFocusOnField();
            }
        });
    }

    public ScreenLogin(String title, Icon logo, Image frameIcon, String version, String defaultPort) {
        this(title, logo, frameIcon, version, defaultPort, null, true);
    }

    public ScreenLogin(String title, Icon logo, Image frameIcon) {
        this(title, logo, frameIcon, null, null);
    }

    public ScreenLogin(Icon logo, Image frameIcon, String version) {
        this(null, logo, frameIcon, version, null);
    }

    public ScreenLogin(Icon logo, Image frameIcon) {
        this(null, logo, frameIcon, null, null);
    }

    public void showConnectionSpeed(boolean connectionSpeed) {
        this.connectionSpeed = connectionSpeed;
        this.connectionSpeedText.setVisible(connectionSpeed);
    }

    public void setControlsEnabled(boolean b) {
        user.setEnabled(b);
        this.pass.setEnabled(b);
        this.login.setEnabled(b);
        this.enableControls();
        this.configButton.setEnabled(b);
        this.encryptedButton.setEnabled(b);
        if (this.groupsBox != null) {
            this.groupsBox.setEnabled(b);
        }
        if (b) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setButtonDefault(this.login);
            this.setButtonDefault(this.cancel);
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.login.setCursor(Cursor.getPredefinedCursor(3));
            this.login.setEnabled(false);
        }
    }

    public void onLoginFailure() {
        this.loginAttempt = false;
        this.setControlsEnabled(true);
        this.displayComponents(true);
    }

    public void cleanFields() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        user.setText("");
        this.pass.setText("");
    }

    public void cleanField(int fieldID) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        switch (fieldID) {
            case 0: {
                user.setText("");
                break;
            }
            case 1: {
                this.pass.setText("");
                break;
            }
            default: {
                this.cleanFields();
            }
        }
    }

    public void close() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setVisible(false);
        this.dispose();
    }

    public void requestFocusOnField() {
        if (this.loginAttempt) {
            return;
        }
        this.setControlsEnabled(true);
        String txt = user.getText();
        if (txt == null || txt.trim().length() == 0) {
            user.requestFocus();
        } else {
            this.pass.requestFocus();
        }
    }

    public boolean hasAttemptedToLogin() {
        return this.loginAttempt;
    }

    public void setQuitButtonText(String text) {
        if (text == null) {
            return;
        }
        if ((text = text.trim()).length() == 0) {
            return;
        }
        if (text.equals(this.cancel.getText())) {
            return;
        }
        this.cancel.setText(text);
        char c = text.toUpperCase().charAt(0);
        this.setQuitButtonMnemonic(c);
    }

    public void setQuitButtonToolTipText(String toolTipText) {
        this.cancel.setToolTipText(toolTipText);
    }

    public void setQuitButtonMnemonic(int mnemonic) {
        this.cancel.setMnemonic(mnemonic);
    }

    public void initProgressBar(int maxTask) {
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(maxTask);
        this.progressBar.setValue(0);
    }

    public void addToLayer(JComponent c) {
        if (c == null) {
            return;
        }
        this.layers.add((Component)c, (Object)1);
    }

    public void setStatus(String value, int perc) {
        this.currentTask.setText(value);
        this.progressBar.setValue(perc);
    }

    public void setStatusVisible(boolean visible, boolean requestFocus) {
        this.currentTask.setVisible(visible);
        this.progressBar.setVisible(visible);
        if (requestFocus) {
            this.login.setEnabled(true);
            this.requestFocusOnField();
        }
    }

    public void setEncryptionConfiguration(boolean encrypted, boolean configurable) {
        if (encrypted && !this.encrypted || !encrypted && this.encrypted) {
            this.encrypt();
        }
        if (!configurable) {
            this.encryptedButton.removeActionListener(this.encryptionListener);
        }
    }

    public void setHostNameConfiguration(String hostName, boolean configurable, int port) {
        this.hostConfigurable = configurable;
        this.configureServerName = hostName;
        if (CommonsLangUtils.isNotBlank(hostName)) {
            if (configurable) {
                Map<String, String> servers = this.editor.getServers();
                if (servers == null || servers.size() == 0) {
                    this.editor.addRow(hostName);
                } else {
                    Iterator<String> i = servers.keySet().iterator();
                    boolean exist = false;
                    while (i.hasNext()) {
                        String value = i.next();
                        if (!hostName.equals(value)) continue;
                        exist = true;
                        break;
                    }
                    if (!exist) {
                        this.editor.addRow(hostName);
                    }
                }
            } else {
                this.originalServerName = this.serverName = hostName;
                this.selectedPort = port < 0 ? Integer.parseInt(this.editor.getDefaultPort()) : port;
                this.setNewServer(this.originalServerName);
            }
        }
    }

    public void setHostNameConfiguration(String hostName, boolean configurable) {
        this.setHostNameConfiguration(hostName, configurable, -1);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("server".equals(name)) {
            String v = this.getServerName();
            String s = (String)evt.getNewValue();
            if (s == null) {
                this.setNewServer(null);
                return;
            }
            String trim = s.trim();
            if (v.equals(trim)) {
                return;
            }
            this.setNewServer(trim);
        } else if ("remove".equals(name)) {
            this.requestFocusOnField();
            String v = this.getServerName();
            String oldValue = (String)evt.getOldValue();
            if (v.equals(oldValue)) {
                this.setNewServer((String)evt.getNewValue());
            }
        } else if ("connectionSpeed".endsWith(name)) {
            this.setConnectionSpeed((Integer)evt.getNewValue());
            this.connectionSpeedText.setText(this.getConnectionSpeed());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.enableControls();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.enableControls();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.login();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

