/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.search;

import java.util.ArrayList;
import java.util.List;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.search.ExperimenterContext;

public class GroupContext {
    private static final int MAX_CHARS = 25;
    public static final int ALL_GROUPS_ID = Integer.MAX_VALUE;
    private String group;
    private long id;
    private List<ExperimenterContext> experimenters = new ArrayList<ExperimenterContext>();

    public GroupContext(String group, long id) {
        if (group.length() > 25) {
            group = UIUtilities.truncate(group, 25, false);
        }
        this.group = group;
        this.id = id;
    }

    public GroupContext(GroupData group) {
        String groupName = group.getName();
        if (groupName.length() > 25) {
            groupName = UIUtilities.truncate(groupName, 25, false);
        }
        this.group = groupName;
        this.id = group.getId();
        for (Object exp : group.getExperimenters()) {
            this.experimenters.add(new ExperimenterContext((ExperimenterData)exp));
        }
    }

    public long getId() {
        return this.id;
    }

    public List<ExperimenterContext> getExperimenters() {
        return this.experimenters;
    }

    public void setExperimenters(List<ExperimenterContext> experimenters) {
        this.experimenters = experimenters;
    }

    public String toString() {
        return this.group;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupContext other = (GroupContext)obj;
        return this.id == other.id;
    }
}

