/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.treetable;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.treetable.editors.BooleanCellEditor;
import org.openmicroscopy.shoola.util.ui.treetable.editors.NumberCellEditor;
import org.openmicroscopy.shoola.util.ui.treetable.editors.StringCellEditor;
import org.openmicroscopy.shoola.util.ui.treetable.model.OMETreeNode;
import org.openmicroscopy.shoola.util.ui.treetable.renderers.BooleanCellRenderer;
import org.openmicroscopy.shoola.util.ui.treetable.renderers.IconCellRenderer;
import org.openmicroscopy.shoola.util.ui.treetable.renderers.NumberCellRenderer;
import org.openmicroscopy.shoola.util.ui.treetable.renderers.SelectionHighLighter;

public class OMETreeTable
extends JXTreeTable {
    protected static final Map<Class<?>, DefaultCellEditor> DEFAULT_EDITORS;
    protected static final Map<Class<?>, TableCellRenderer> DEFAULT_RENDERERS;
    protected TreeExpansionListener treeExpansionListener;

    public OMETreeTable() {
    }

    public OMETreeTable(TreeTableModel model) {
        super(model);
        this.setTableModel(model);
    }

    public void setTableModel(TreeTableModel model) {
        this.setTreeTableModel(model);
    }

    protected void setDefaultHighLighter() {
        Highlighter h = HighlighterFactory.createAlternateStriping((Color)UIUtilities.BACKGROUND_COLOUR_EVEN, (Color)UIUtilities.BACKGROUND_COLOUR_ODD);
        this.addHighlighter(h);
        this.addHighlighter((Highlighter)new SelectionHighLighter(this));
    }

    protected boolean leftClick(MouseEvent e) {
        return e.getButton() == 1;
    }

    protected void setListeners() {
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OMETreeTable.this.onMouseClicked(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                OMETreeTable.this.onMouseEnter(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                OMETreeTable.this.onMouseExit(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                OMETreeTable.this.onMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                OMETreeTable.this.onMouseReleased(e);
            }
        };
        this.addMouseListener(mouseListener);
    }

    protected void onMouseClicked(MouseEvent e) {
    }

    protected void onMouseReleased(MouseEvent e) {
    }

    protected void onMousePressed(MouseEvent e) {
    }

    protected void onMouseEnter(MouseEvent e) {
    }

    protected void onMouseExit(MouseEvent e) {
    }

    protected void setTreeExpansionListener() {
        this.treeExpansionListener = new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
                OMETreeTable.this.onNodeNavigation(e, false);
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                OMETreeTable.this.onNodeNavigation(e, true);
            }
        };
        this.addTreeExpansionListener(this.treeExpansionListener);
    }

    protected void onNodeNavigation(TreeExpansionEvent e, boolean expanded) {
        OMETreeNode node = (OMETreeNode)((Object)e.getPath().getLastPathComponent());
        node.setExpanded(expanded);
    }

    protected void setDefaultEditors() {
        for (Class<?> classType : DEFAULT_EDITORS.keySet()) {
            DefaultCellEditor editorType = DEFAULT_EDITORS.get(classType);
            this.setDefaultEditor(classType, editorType);
        }
    }

    protected void setDefaultRenderers() {
        for (Class<?> classType : DEFAULT_RENDERERS.keySet()) {
            TableCellRenderer rendererType = DEFAULT_RENDERERS.get(classType);
            this.setDefaultRenderer(classType, rendererType);
        }
    }

    public void expandNode(OMETreeNode node) {
        if (node != null) {
            this.expandPath(node.getPath());
        }
    }

    public void collapseNode(OMETreeNode node) {
        if (node != null) {
            this.collapsePath(node.getPath());
        }
    }

    public void expandPath(TreePath path) {
        super.expandPath(path);
        if (path == null) {
            return;
        }
        OMETreeNode node = (OMETreeNode)((Object)path.getLastPathComponent());
        if (node != null) {
            node.setExpanded(true);
        }
    }

    public void expandRow(int row) {
        super.expandRow(row);
        OMETreeNode node = this.getNodeAtRow(row);
        if (node != null) {
            node.setExpanded(true);
        }
    }

    public void expandAll() {
        super.expandAll();
        MutableTreeTableNode root = (MutableTreeTableNode)this.getTreeTableModel().getRoot();
        if (root == null) {
            return;
        }
        for (MutableTreeTableNode node : ((OMETreeNode)root).getChildList()) {
            ((OMETreeNode)node).setExpanded(true);
        }
    }

    public OMETreeNode getNodeAtRow(int row) {
        TreePath path = this.getPathForRow(row);
        if (path == null) {
            return null;
        }
        return (OMETreeNode)((Object)path.getLastPathComponent());
    }

    public int getRow(OMETreeNode node) {
        if (node == null) {
            return -1;
        }
        return this.getRowForPath(node.getPath());
    }

    public boolean isCellEditable(Object node, int column) {
        return this.getTreeTableModel().isCellEditable(node, column);
    }

    public void selectNode(OMETreeNode node) {
        int row = this.getRow(node);
        this.selectionModel.addSelectionInterval(row, row);
    }

    public void collapsePath(TreePath path) {
        super.collapsePath(path);
        if (path == null) {
            return;
        }
        OMETreeNode node = (OMETreeNode)((Object)path.getLastPathComponent());
        if (node != null) {
            node.setExpanded(false);
        }
    }

    public void collapseRow(int row) {
        super.collapseRow(row);
        OMETreeNode node = this.getNodeAtRow(row);
        if (node != null) {
            node.setExpanded(false);
        }
    }

    public void collapseAll() {
        super.collapseAll();
        MutableTreeTableNode root = (MutableTreeTableNode)this.getTreeTableModel().getRoot();
        if (root == null) {
            return;
        }
        for (MutableTreeTableNode node : ((OMETreeNode)root).getChildList()) {
            ((OMETreeNode)node).setExpanded(false);
        }
    }

    public void setTreeTableModel(TreeTableModel model) {
        super.setTreeTableModel(model);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setCellSelectionEnabled(false);
        this.setTreeExpansionListener();
        this.setListeners();
        this.setDefaultRenderers();
        this.setDefaultEditors();
        this.setDefaultHighLighter();
    }

    static {
        DEFAULT_RENDERERS = new HashMap();
        DEFAULT_RENDERERS.put(Boolean.class, new BooleanCellRenderer());
        DEFAULT_RENDERERS.put(Long.class, new NumberCellRenderer());
        DEFAULT_RENDERERS.put(Integer.class, new NumberCellRenderer());
        DEFAULT_RENDERERS.put(Float.class, new NumberCellRenderer());
        DEFAULT_RENDERERS.put(Double.class, new NumberCellRenderer());
        DEFAULT_RENDERERS.put(String.class, new NumberCellRenderer(2));
        DEFAULT_RENDERERS.put(Icon.class, new IconCellRenderer());
        DEFAULT_EDITORS = new HashMap();
        DEFAULT_EDITORS.put(Boolean.class, new BooleanCellEditor((JCheckBox)((Object)DEFAULT_RENDERERS.get(Boolean.class))));
        DEFAULT_EDITORS.put(Integer.class, new NumberCellEditor(new JTextField()));
        DEFAULT_EDITORS.put(String.class, new StringCellEditor(new JTextField()));
    }
}

