/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application.action;

import application.ResourceMap;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.application.DocumentView;
import org.jhotdraw.application.action.AbstractDocumentViewAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.util.ResourceBundleUtil;

public abstract class AbstractSaveBeforeAction
extends AbstractDocumentViewAction {
    private Component oldFocusOwner;

    public void actionPerformed(ActionEvent evt) {
        final DocumentView p = this.getCurrentView();
        if (p.isEnabled()) {
            final ResourceMap labels = this.getFrameworkResourceMap();
            Window wAncestor = SwingUtilities.getWindowAncestor(p.getComponent());
            this.oldFocusOwner = wAncestor == null ? null : wAncestor.getFocusOwner();
            p.setEnabled(false);
            if (p.isModified()) {
                JOptionPane pane = new JOptionPane("<html>" + UIManager.getString("OptionPane.css") + labels.getString("File.saveBefore.OptionPane.message", new Object[0]), 2);
                Object[] options = new Object[]{labels.getString("File.save.Button.text", new Object[0]), labels.getString("OptionPane.cancel.Button.text", new Object[0]), labels.getString("File.dontSave.Button.text", new Object[0])};
                pane.setOptions(options);
                pane.setInitialValue(options[0]);
                pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
                JSheet.showSheet(pane, p.getComponent(), new SheetListener(){

                    public void optionSelected(SheetEvent evt) {
                        Object value = evt.getValue();
                        if (value == null || value.equals(labels.getString("OptionPane.cancel.Button.text", new Object[0]))) {
                            p.setEnabled(true);
                        } else if (value.equals(labels.getString("File.dontSave.Button.text", new Object[0]))) {
                            AbstractSaveBeforeAction.this.doIt(p);
                            p.setEnabled(true);
                        } else if (value.equals(labels.getString("File.save.Button.text", new Object[0]))) {
                            AbstractSaveBeforeAction.this.saveChanges(p);
                        }
                    }
                });
            } else {
                this.doIt(p);
                p.setEnabled(true);
                if (this.oldFocusOwner != null) {
                    this.oldFocusOwner.requestFocus();
                }
            }
        }
    }

    protected void saveChanges(final DocumentView p) {
        if (p.getFile() == null) {
            JFileChooser fileChooser = p.getSaveChooser();
            JSheet.showSaveSheet(fileChooser, p.getComponent(), new SheetListener(){

                public void optionSelected(SheetEvent evt) {
                    if (evt.getOption() == 0) {
                        File file = evt.getFileChooser().getFileFilter() instanceof ExtensionFileFilter ? ((ExtensionFileFilter)evt.getFileChooser().getFileFilter()).makeAcceptable(evt.getFileChooser().getSelectedFile()) : evt.getFileChooser().getSelectedFile();
                        AbstractSaveBeforeAction.this.saveToFile(p, file);
                    } else {
                        p.setEnabled(true);
                        if (AbstractSaveBeforeAction.this.oldFocusOwner != null) {
                            AbstractSaveBeforeAction.this.oldFocusOwner.requestFocus();
                        }
                    }
                }
            });
        } else {
            this.saveToFile(p, p.getFile());
        }
    }

    protected void saveToFile(final DocumentView p, final File file) {
        p.execute(new Worker(){

            public Object construct() {
                try {
                    p.write(file);
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            public void finished(Object value) {
                AbstractSaveBeforeAction.this.fileSaved(p, file, value);
            }
        });
    }

    protected void fileSaved(DocumentView p, File file, Object value) {
        if (value == null) {
            p.setFile(file);
            p.setModified(false);
            this.doIt(p);
        } else {
            ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.application.Labels");
            JSheet.showMessageSheet((Component)p.getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + labels.getFormatted("couldntSave", file, value)), 0);
        }
        p.setEnabled(true);
        if (this.oldFocusOwner != null) {
            this.oldFocusOwner.requestFocus();
        }
    }

    protected abstract void doIt(DocumentView var1);
}

