/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.jhotdraw.application.DocumentView;
import org.jhotdraw.application.action.AbstractDocumentViewAction;

public class RedoAction
extends AbstractDocumentViewAction {
    public static final String ID = "Edit.redo";
    private PropertyChangeListener redoActionPropertyListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == "Name") {
                RedoAction.this.putValue("Name", evt.getNewValue());
            } else if (name == "enabled") {
                RedoAction.this.updateEnabledState();
            }
        }
    };

    public RedoAction() {
        this.initActionProperties(ID);
    }

    protected void updateEnabledState() {
        boolean isEnabled = false;
        Action realRedoAction = this.getRealRedoAction();
        if (realRedoAction != null) {
            isEnabled = realRedoAction.isEnabled();
        }
        this.setEnabled(isEnabled);
    }

    protected void updateProject(DocumentView oldValue, DocumentView newValue) {
        super.updateProject(oldValue, newValue);
        if (newValue != null && newValue.getAction("redo") != null) {
            this.putValue("Name", newValue.getAction("redo").getValue("Name"));
            this.updateEnabledState();
        }
    }

    protected void installProjectListeners(DocumentView p) {
        super.installProjectListeners(p);
        if (p.getAction("redo") != null) {
            p.getAction("redo").addPropertyChangeListener(this.redoActionPropertyListener);
        }
    }

    protected void uninstallProjectListeners(DocumentView p) {
        super.uninstallProjectListeners(p);
        if (p.getAction("redo") != null) {
            p.getAction("redo").removePropertyChangeListener(this.redoActionPropertyListener);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Action realRedoAction = this.getRealRedoAction();
        if (realRedoAction != null) {
            realRedoAction.actionPerformed(e);
        }
    }

    private Action getRealRedoAction() {
        return this.getCurrentView() == null ? null : this.getCurrentView().getAction("redo");
    }
}

