/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreationTool
extends AbstractTool {
    private Map<AttributeKey, Object> prototypeAttributes;
    private String presentationName;
    private Dimension minimalSizeTreshold = new Dimension(2, 2);
    private Dimension minimalSize = new Dimension(40, 40);
    private Figure prototype;
    protected Figure createdFigure;

    public CreationTool(String prototypeClassName) {
        this(prototypeClassName, null, null);
    }

    public CreationTool(String prototypeClassName, Map<AttributeKey, Object> attributes) {
        this(prototypeClassName, attributes, null);
    }

    public CreationTool(String prototypeClassName, Map<AttributeKey, Object> attributes, String name) {
        try {
            this.prototype = (Figure)Class.forName(prototypeClassName).newInstance();
        }
        catch (Exception e) {
            InternalError error = new InternalError("Unable to create Figure from " + prototypeClassName);
            error.initCause(e);
            throw error;
        }
        this.prototypeAttributes = attributes;
        if (name == null) {
            ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
            name = labels.getString("createFigure");
        }
        this.presentationName = name;
    }

    public CreationTool(Figure prototype) {
        this(prototype, null, null);
    }

    public CreationTool(Figure prototype, Map<AttributeKey, Object> attributes) {
        this(prototype, attributes, null);
    }

    public CreationTool(Figure prototype, Map<AttributeKey, Object> attributes, String name) {
        this.prototype = prototype;
        this.prototypeAttributes = attributes;
        if (name == null) {
            ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
            name = labels.getString("createFigure");
        }
        this.presentationName = name;
    }

    public Figure getPrototype() {
        return this.prototype;
    }

    @Override
    public void activate(DrawingEditor editor) {
        super.activate(editor);
    }

    @Override
    public void deactivate(DrawingEditor editor) {
        super.deactivate(editor);
        if (this.getView() != null) {
            this.getView().setCursor(Cursor.getDefaultCursor());
        }
        if (this.createdFigure != null) {
            if (this.createdFigure instanceof CompositeFigure) {
                ((CompositeFigure)this.createdFigure).layout();
            }
            this.createdFigure = null;
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        this.getView().clearSelection();
        this.createdFigure = this.createFigure();
        Point2D.Double p = this.constrainPoint(this.viewToDrawing(this.anchor));
        this.anchor.x = evt.getX();
        this.anchor.y = evt.getY();
        this.createdFigure.setBounds(p, p);
        this.getDrawing().add(this.createdFigure);
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (this.createdFigure != null) {
            Point2D.Double p = this.constrainPoint(new Point(evt.getX(), evt.getY()));
            this.createdFigure.willChange();
            this.createdFigure.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), p);
            this.createdFigure.changed();
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (this.createdFigure != null) {
            Rectangle2D.Double bounds = this.createdFigure.getBounds();
            if (bounds.width == 0.0 && bounds.height == 0.0) {
                this.getDrawing().remove(this.createdFigure);
                this.fireToolDone();
            } else {
                if (Math.abs(this.anchor.x - evt.getX()) < this.minimalSizeTreshold.width && Math.abs(this.anchor.y - evt.getY()) < this.minimalSizeTreshold.height) {
                    this.createdFigure.willChange();
                    this.createdFigure.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, (double)this.minimalSize.width), this.anchor.y + (int)Math.max(bounds.height, (double)this.minimalSize.height))));
                    this.createdFigure.changed();
                }
                this.getView().addToSelection(this.createdFigure);
                if (this.createdFigure instanceof CompositeFigure) {
                    ((CompositeFigure)this.createdFigure).layout();
                }
                final Figure addedFigure = this.createdFigure;
                final Drawing addedDrawing = this.getDrawing();
                this.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit(){

                    public String getPresentationName() {
                        return CreationTool.this.presentationName;
                    }

                    public void undo() throws CannotUndoException {
                        super.undo();
                        addedDrawing.remove(addedFigure);
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        addedDrawing.add(addedFigure);
                    }
                });
                this.creationFinished(this.createdFigure);
            }
        } else {
            this.fireToolDone();
        }
    }

    protected Figure createFigure() {
        Figure f = (Figure)this.prototype.clone();
        this.getEditor().applyDefaultAttributesTo(f);
        if (this.prototypeAttributes != null) {
            for (Map.Entry<AttributeKey, Object> entry : this.prototypeAttributes.entrySet()) {
                f.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return f;
    }

    protected Figure getCreatedFigure() {
        return this.createdFigure;
    }

    protected Figure getAddedFigure() {
        return this.createdFigure;
    }

    protected void creationFinished(Figure createdFigure) {
        this.fireToolDone();
    }
}

