/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.quality.AbstractQFStatisticBased;
import org.vikamine.kernel.util.VKMUtil;

public class DyadicMultiWeightedLiftCompletedQF
extends AbstractQFStatisticBased {
    private static final String ID = "DyadicMultiWeightedLiftQF";
    private static final String NAME = "DyadicMultiWeightedLiftQF";

    @Override
    public String getID() {
        return "DyadicMultiWeightedLiftQF";
    }

    @Override
    public String getName() {
        return "DyadicMultiWeightedLiftQF";
    }

    @Override
    public AbstractQFStatisticBased clone() {
        return new DyadicMultiWeightedLiftCompletedQF();
    }

    @Override
    public boolean isApplicable(SG subgroup) {
        return true;
    }

    @Override
    public double evaluate(SGStatistics statistics) {
        SG subgroup = statistics.getSubgroup();
        double weightedObservedDyads = statistics.getTargetQuantitySG() * statistics.getSubgroupSize();
        double expectedDyads = VKMUtil.asList(subgroup.subgroupInstanceIterator()).size();
        return Math.abs(weightedObservedDyads / expectedDyads);
    }
}

