/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.optimization.cmaes.fitness;

import fr.inria.optimization.cmaes.fitness.AbstractObjectiveFunction;

class Rastrigin
extends AbstractObjectiveFunction {
    public double axisratio = 1.0;
    public double amplitude = 10.0;

    Rastrigin() {
        this(1.0, 10.0);
    }

    Rastrigin(double axisratio, double amplitude) {
        this.axisratio = axisratio;
        this.amplitude = amplitude;
    }

    @Override
    public double valueOf(double[] x) {
        double res = 0.0;
        int i = 0;
        while (i < x.length) {
            double fac = Math.pow(this.axisratio, ((double)i - 1.0) / ((double)x.length - 1.0));
            if (i == 0 && x[i] < 0.0) {
                fac *= 1.0;
            }
            res += fac * fac * x[i] * x[i] + this.amplitude * (1.0 - Math.cos(Math.PI * 2 * fac * x[i]));
            ++i;
        }
        return res;
    }
}

