## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(wordler)

## -----------------------------------------------------------------------------
# Commented out so vignette can be generated
#play_wordler()

## -----------------------------------------------------------------------------
game <- new_wordler()

## -----------------------------------------------------------------------------
game <- have_a_guess("SQUID", game, allowed_words = c(wordle_answers, wordle_allowed))
game <- have_a_guess("VIDEO", game, allowed_words = c(wordle_answers, wordle_allowed))

## -----------------------------------------------------------------------------
game <- have_a_guess("DONKY", game, allowed_words = c(wordle_answers, wordle_allowed))

## -----------------------------------------------------------------------------
game$game_over

## -----------------------------------------------------------------------------
game$game_won

## -----------------------------------------------------------------------------
game$guess_count

## -----------------------------------------------------------------------------
game$target

## -----------------------------------------------------------------------------
game$guess

## -----------------------------------------------------------------------------
game$assess

## -----------------------------------------------------------------------------
print(game)

## -----------------------------------------------------------------------------
game$letters_known_not_in_word

## -----------------------------------------------------------------------------
game$letters_known_in_word

## -----------------------------------------------------------------------------
game$letters_known_in_position

