\name{cl.code}
\title{Classification Code Handling}
\usage{
as.cl.code (fact)
as.factor.cl.code (code, levels)
}
\alias{as.cl.code}
\alias{as.cl.code.factor}
\alias{as.factor.cl.code}
\arguments{
  \item{fact}{a factor variable.}
  \item{code}{a \code{1} of \code{c} classification code.}
  \item{levels}{the levels of a factor.}
}
\description{
  \code{as.cl.code} returns a \code{1} of \code{c} coding of \code{fact}.
  
  \code{as.factor.cl.code} computes from the \code{1} of \code{c} coding \code{code}
  the factor with corresponding \code{levels}.
}
\value{
  A \code{1} of \code{c} coding or a factor, respectively.
\author{A. Trapletti}
\examples{
species1 <- as.factor (c(rep("s",50), rep("c", 50), rep("v", 50)))
cd <- as.cl.code (species1)
species2 <- as.factor.cl.code (cd, levels(species1))
}
\keyword{category}

