#ifdef  IDBUG_OS_MSDOS

void
idbug_init_security (idbug_t * idbug)
{
	idbug->security.pchown = NULL;
	idbug->security.pgetuid = NULL;
	idbug->security.pgetgid = NULL;
}

/*
 *  FUNCTION
 *
 * Writable    test to see if a pathname is writable/creatable
 *
 *  SYNOPSIS
 *
 * static int Writable (pathname)
 * char *pathname;
 *
 *  DESCRIPTION
 *
 * Because the debugger might be linked in with a program that
 * runs with the set-uid-bit (suid) set, we have to be careful
 * about opening a user named file for debug output.  This consists
 * of checking the file for write access with the real user id,
 * or checking the directory where the file will be created.
 *
 * Returns TRUE if the user would normally be allowed write or
 * create access to the named file.  Returns FALSE otherwise.
 *
 */

int
idbug_writable (idbug_t * idbug, const char *pathname)
{
  return 1;
}

#endif /* IDBUG_OS_MSDOS */
