#***********************************************************************************************************************************************
#*  
#*  (C) 2011     Marek Walesiak     Uniwersytet Ekonomiczny we Wrocawiu
#*  
#*  Skrypt do ksiki:
#*  "Analiza danych jakociowych i symbolicznych z wykorzystaniem programu R", C.H. Beck, Warszawa 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

d<-read.csv2("maddala_data_pwn.csv",header=TRUE,row.names=1)
attach(d)
options(OutDec=",")
reg<-glm(D1~T+Y+LF+NW,binomial(link="logit"),data=d,x=TRUE,y=TRUE)
print("Prognozy na podstawie modeli dwumianowych",quote=FALSE)
print("1a. Prognoza Pi dla obserwacji w prbie",quote=FALSE)
Pwp<-predict(reg,type="response")
print(Pwp)
print("1b. Prognoza Pi dla obserwacji poza prb", quote=FALSE)
nd<-read.csv2("maddala_data_pwn_p.csv",header=TRUE,row.names=1)
Ppp<-predict(reg,newdata=nd,type="response")
print(Ppp)
print("2a. Prognoza yi (1 lub 0)  prba zbilansowana",quote=FALSE)
print("Tablica trafnoci",quote=FALSE)
fv<-as.matrix(reg$fitted.values)
przewidywane<-as.integer((fv[,1]>0.5))
faktyczne<-reg$y
tab_traf<-table(faktyczne,przewidywane)
print(tab_traf)
print("Mierniki dokadnoci prognoz - prba zbilansowana",quote=FALSE)
print("Procentowa trafno prognozowania",quote=FALSE)
tp<-sum(tab_traf[row(tab_traf)==col(tab_traf)])/sum(tab_traf)
print(tp)
print("Iloraz szans",quote=FALSE)
is<-(prod(tab_traf[row(tab_traf)==col(tab_traf)])/prod(tab_traf[row(tab_traf)!=col(tab_traf)]))
print(is)
print("2b. Prognoza yi (1 lub 0)  prba niezbilansowana",quote=FALSE)
print("Tablica trafnoci - prba niezbilansowana",quote=FALSE)
fv_n<-as.matrix(reg$fitted.values)
przewidywane_n<-as.integer((fv_n[,1]>sum(reg$y)/nrow(d)))
faktyczne<-reg$y
tab_traf_n<-table(faktyczne,przewidywane_n)
print(tab_traf_n)
print("Mierniki dokadnoci prognoz - prba niezbilansowana",quote=FALSE)
print("Procentowa trafno prognozowania",quote=FALSE)
tp_n<-sum(tab_traf_n[row(tab_traf_n)==col(tab_traf_n)])/sum(tab_traf_n)
print(tp_n)
print("Iloraz szans",quote=FALSE)
is_n<-(prod(tab_traf_n[row(tab_traf_n)==col(tab_traf_n)])/prod(tab_traf_n[row(tab_traf_n)!=col(tab_traf_n)]))
print(is_n)
detach(d)