#Lo primero, situarnos en el directorio de trabajo
setwd("D:/Asignaturas/Curso R")

#############################CONTRASTE SOBRE LA MEDIA DE UNA POBLACIN

#Primero importamos los datos
Datos.cebollas<-read.table("cebollas.txt",header=TRUE,dec=",")
#Cmo se llama la variable?
names(Datos.cebollas)#Se llama Kilos
#Ahora hacemos el test para contrastar H0:mu=2 frente a H1:mu distinto de 2
t.test(Datos.cebollas$Kilos,alternative="two.sided",mu=2)

#############################CONTRASTE DE COMPARACIN DE DOS MEDIAS EN POBLACIONES INDEPENDIENTES

#Primero importamos los datos
Datos.feromona<-read.table("feromona.txt",header=TRUE)
#Cmo se llaman las variables?
names(Datos.feromona)#Se llaman "Capturas.producto.tradicional" y "Capturas.feromona"
#Fjate que las variables vienen separadas en dos, una para la feromona y otra para el producto tradicional
#En tonces, el test se hace as:
#Queremos contrastar que la media con la feromona es mayor que con el producto tradicional
t.test(x=Datos.feromona$Capturas.feromona,y=Datos.feromona$Capturas.producto.tradicional,alternative="greater",mu=0)  

#Y si los datos vienen "apilados"?
#Los datos tambin podran venir as
Capturas<-c(Datos.feromona$Capturas.feromona,Datos.feromona$Capturas.producto.tradicional)
Trampa<-c(rep("Feromona",length(Datos.feromona$Capturas.feromona)),rep("Producto tradicional",length(Datos.feromona$Capturas.producto.tradicional)))
Trampa<-as.factor(Trampa)
Datos.feromona.apilados<-data.frame(Capturas,Trampa)
Datos.feromona.apilados
#Es decir, los datos sobre las capturas en cada trampa vienen en una variable y en otro variable tipo factor viene el tipo de trampa, tradicional o de feromona.
#En ese caso, el contraste se hace as
t.test(Capturas~Trampa,data=Datos.feromona.apilados,alternative="greater",mu=0)#Ojo: ordena el factor por orden alfabtico


#############################CONTRASTE DE COMPARACIN DE MEDIAS EN POBLACIONES PAREADAS

#Primero importamos los datos
Datos.curso<-read.table("curso.txt",header=TRUE,dec=",")
#Cmo se llaman las variables?
names(Datos.curso)#Las que nos interesan se llaman "Antes.del.curso" y "Despues.del.curso"
#Ahora hacemos el test para contrastar que la media despus del curso es menor que antes del curso
t.test(x=Datos.curso$Despues.del.curso,y=Datos.curso$Antes.del.curso,alternative="less",mu=0,paired=TRUE) 

############################CONTRASTE CHI-CUADRADO SOBRE UNA PROPORCION
#El artculo Refinement of Gravimetric Geoid Using GPS and Leveling Data (W. Thurston, en Journal of Surveing
# Engineering, 2000:27-56) presenta un mtodo para medir las alturas ortomtricas por encima del nivel del mar. 
#Para una muestra de 1225 puntos de partida, 926 dieron resultados que estn dentro del espritu de la clase C 
#nivelando los lmites de tolerancia. Se puede concluir que este mtodo produce resultados dentro de los lmites 
#de tolerancia ms del 75% de las veces?

prop.test(x=926,n=1225,p=0.75,alternative="greater",correct=FALSE)

############################CONTRASTE CHI-CUADRADO SOBRE DOS PROPORCIONES
#A raz de la alarma creada entre la opinin pblica por la repercusin que tuvo el caso de un bloque de edificios
# con un transformador en su planta baja y donde un gran porcentaje de vecinos sufri cncer, se decide realizar un
# estudio para tratar de encontrar relacin entre la cercana de un transformador elctrico y la incidencia del cncer.
##Para ello, se eligi una muestra aleatoria de edificios con transformadores en su planta baja durante un periodo 
#de ms de 10 aos, contabilizando el nmero de habitantes en ellos, 2150, y todos los casos de cncer detectados 
#en los 5 ltimos aos, 37. Por su parte, se recolect otra muestra aleatoria de control con edificios que no tuvieran
# ningn transformador elctrico cercano, contabilizando tambin el nmero de personas, 2200, y el nmero de casos de 
#cncer en ellos en los ltimos 5 aos, 33. En ambas muestras, los expertos procuraron eliminar la posibilidad de ruido,
# es decir, la presencia de otros factores que pudieran incidir en variar la incidencia del cncer en alguna de las muestras.
#A la luz de los datos de este estudio, podemos afirmar que la cercana de un transformador elctrico aumenta la
# proporcin de casos de cncer? (Utilcese un nivel de significacin del 5%) 

tabla<-matrix(c(37,2113,33,2167),2,2,byrow=TRUE) 
prop.test(tabla, alternative="greater", correct=FALSE)

#########################CONTRASTE DE COMPARACIN DE VARIANZAS DE VARIABLES NORMALES INDEPENDIENTES

#Primero importamos los datos
Datos.aceite<-read.table("aceite.txt",header=TRUE,sep="\t",dec=",")
#Fjate que los datos de las mquinas vienen separadas en dos variables
#Ahora, sabiendo que las variables de las mquinas estn separadas, contrastamos si con la nueva mquina la varianza es menos
var.test(Datos.aceite$Nueva.maquina,Datos.aceite$Vieja.maquina,alternative="less")

#Y si los datos vienen "apilados"? Podran venir as:
Litros<-c(Datos.aceite$Nueva.maquina,Datos.aceite$Vieja.maquina)
Maquina<-c(rep("Nueva",length(Datos.aceite$Nueva.maquina)),rep("Vieja",length(Datos.aceite$Vieja.maquina)))
Maquina<-as.factor(Maquina)
Datos.aceite.apilados<-data.frame(Litros,Maquina)
Datos.aceite.apilados
#Es decir, una primera variable me dice los litros que se envasan en cada prueba y la segunda variable, de tipo factor, me dice en qu tipo de mquina se hizo la prueba, vieja o nueva
#Entonces, el contraste se hace as
var.test(Litros~Maquina,data=Datos.aceite,alternative="less")#Ojo: ordena el factor por orden alfabtico


########################ANOVA
#Primero importamos los datos
Datos<-read.table("SO2.txt",header=TRUE,sep="\t",dec=",")
Datos
#Ahora no queda ms remedio que apilar los datos
x1<-Datos$Planta1[is.na(Datos$Planta1)==0]
n1<-length(x1)
x2<-Datos$Planta2[is.na(Datos$Planta2)==0]
n2<-length(x2)
x3<-Datos$Planta3[is.na(Datos$Planta3)==0]
n3<-length(x3)
x4<-Datos$Planta4[is.na(Datos$Planta4)==0]
n4<-length(x4)
Datos.plantas<-data.frame(Variable=c(x1,x2,x3,x4),Grupo=factor(c(rep(1,n1),rep(2,n2),rep(3,n3),rep(4,n4))))
anova.plantas<-aov(Variable~Grupo,data=Datos.plantas)
summary(anova.plantas) 
plot(TukeyHSD(anova.plantas))