C-----------------------------------------------------------------------
C
C  R : A COMPUTER LANGAGE FOR STATISTICAL DATA ANALYSIS
C  COPYRIGHT (C) 1996  ROBERT GENTLEMAN AND ROSS IHAKA
C
C  THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C  IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C  THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
C  (AT YOUR OPTION) ANY LATER VERSION.
C
C  THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL,
C  BUT WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  SEE THE
C  GNU GENERAL PUBLIC LICENSE FOR MORE DETAILS.
C
C  YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C  ALONG WITH THIS PROGRAM; IF NOT, WRITE TO THE FREE SOFTWARE
C  FOUNDATION, INC., 675 MASS AVE, CAMBRIDGE, MA 02139, USA.
C
C-----------------------------------------------------------------------
C
C     CHOL PERFORMS THE CHOLESKI DECOMPOSITION OF A SYMMETRIC
C     POSITIVE-DEFINITE MATRIX.  THIS IS JUST A WRAPPER FOR THE
C     LINPACK ROUTINE DPOFA.
C
C     ON ENTRY
C
C         A         DOUBLE PRECISION(LDA,N)
C                   THE UPPER TRIANGLE OF THE MATRIX TO BE FACTORIZED
C                   IS CONTAINED IN THE UPPER TRIANGLE OF A.
C
C         LDA       INTEGER
C                   THE LEADING DIMENSION OF A.
C
C         N         INTEGER
C                   THE NUMBER OR ROWS AND COLUMNS OF THE MATRIX
C                   TO BE FACTORIZED.
C
C     ON RETURN
C
C         V         DOUBLE PRECISION(N,N)
C                   THE SQUARE-ROOT (CHOLESKI) FACTOR.
C
C         INFO      INTEGER
C                   THE ERROR INDICATOR FROM DPOFA.  THIS WILL BE
C                   ZERO UNLESS THE MATRIX BEING FACTORIZED IS
C                   NOT POSITIVE DEFINITE.
C
C     THIS VERSION DATED AUG 25, 1996.
C     ROSS IHAKA, UNIVERSITY OF AUCKLAND.
C
      SUBROUTINE CHOL(A, LDA, N, V, INFO)
      DOUBLE PRECISION A(LDA, N), V(N,N)
      INTEGER I, J
C
      DO 20 I = 1,N
        DO 10 J = 1,N
          IF(I .GT. J) THEN
            V(I,J) = 0.0D0
          ELSE
            V(I,J) = A(I,J)
          END IF
   10   CONTINUE
   20 CONTINUE
      CALL DPOFA(V, N, N, INFO)
      RETURN
      END
