C-----------------------------------------------------------------------
C
C  R : A COMPUTER LANGAGE FOR STATISTICAL DATA ANALYSIS
C  COPYRIGHT (C) 1996  ROBERT GENTLEMAN AND ROSS IHAKA
C
C  THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C  IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C  THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
C  (AT YOUR OPTION) ANY LATER VERSION.
C
C  THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL,
C  BUT WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  SEE THE
C  GNU GENERAL PUBLIC LICENSE FOR MORE DETAILS.
C
C  YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C  ALONG WITH THIS PROGRAM; IF NOT, WRITE TO THE FREE SOFTWARE
C  FOUNDATION, INC., 675 MASS AVE, CAMBRIDGE, MA 02139, USA.
C
C-----------------------------------------------------------------------
C
C     LMINFL COMPUTES BASIC QUANTITIES USEFUL FOR COMPUTING
C     REGRESSION DIAGNOSTICS.
C
C     ON ENTRY
C
C         X         DOUBLE PRECISION(LDX,K)
C                   THE QR DECOMPOSITION AS COMPUTED BY DQRDC OR DQRDC2.
C
C         LDX       INTEGER
C                   THE LEADING DIMENSION OF THE ARRAY X.
C
C         N         INTEGER
C                   THE NUMBER OF ROWS OF THE MATRIX X.
C
C         K         INTEGER
C                   THE NUMBER OF COLUMNS IN THE MATRIX K.
C
C         QRAUX     DOUBLE PRECISION(K)
C                   AUXILIARY INFORMATION ABOUT THE QR DECOMPOSITION.
C
C         B         DOUBLE PRECISION(K)
C                   THE LEAST-SQUARES PARAMETER ESTIMATES.
C
C         RESID     DOUBLE PRECISION(K)
C                   THE RESIDUALS FROM THE REGRESSION.
C
C     ON RETURN
C
C         HAT       DOUBLE PRECISION(N)
C                   THE DIAGONAL OF THE HAT MATRIX.
C
C         COEF      DOUBLE PRECISION(N,P)
C                   A MATRIX WHICH HAS AS I-TH ROW CONTAINS THE ESTIMATED
C                   REGRESSION COEFFICIENTS WHEN THE I-TH CASE IS OMITTED
C                   FROM THE REGRESSION.
C
C         SIGMA     DOUBLE PRECISION(N)
C                   THE I-TH ELEMENT OF SIGMA CONTAINS AN ESTIMATE
C                   OF THE RESIDUAL STANDARD DEVIATION FOR THE MODEL WITH
C                   THE I-TH CASE OMITTED.
C
C     THIS VERSION DATED AUG 24, 1996.
C     ROSS IHAKA, UNIVERSITY OF AUCKLAND.
C
      SUBROUTINE LMINFL(X, LDX, N, K, QRAUX, B, RESID, HAT, COEF, SIGMA)
      DOUBLE PRECISION X(LDX,K), QRAUX(K), B(K), RESID(N)
      DOUBLE PRECISION HAT(N), COEF(N,K), SIGMA(N)
      INTEGER LDX, N, K
C
      INTEGER I, J, INFO
      DOUBLE PRECISION SUM, DENOM, DUMMY
      PARAMETER(ZERO = 0.0D0, ONE = 1.0D0)
C
C     HAT MATRIX DIAGONAL
C
      DO 10 I = 1,N
        HAT(I) = ZERO
   10 CONTINUE
	
      DO 40 J = 1,K
        DO 20 I = 1,N
          SIGMA(I) = ZERO
   20   CONTINUE
        SIGMA(J) = ONE
        CALL DQRSL(X, LDX, N, K, QRAUX, SIGMA, SIGMA, DUMMY,
     .      DUMMY, DUMMY, DUMMY, 10000, INFO)
        DO 30 I = 1, N
          HAT(I) = HAT(I)+SIGMA(I)*SIGMA(I)
   30   CONTINUE
   40 CONTINUE
C
C     CHANGES IN THE ESTIMATED COEFFICIENTS
C
      DO 70 I = 1,N
        DO 50 J = 1,N
          SIGMA(J) = ZERO
   50   CONTINUE
        SIGMA(I) = RESID(I)/(ONE - HAT(I))
        CALL DQRSL(X, LDX, N, K, QRAUX, SIGMA, DUMMY, SIGMA,
     .             DUMMY, DUMMY, DUMMY, 1000, INFO)
        CALL DTRSL(X, LDX, K, SIGMA, 1, INFO)
        DO 60 J = 1,K
          COEF(I,J) = SIGMA(J)
   60   CONTINUE
   70 CONTINUE
C
C     ESTIMATED RESIDUAL STANDARD DEVIATION
C
      DENOM = (N - K - 1)
      SUM = 0
      DO 80 I = 1,N
        SUM = SUM + RESID(I)*RESID(I)
   80 CONTINUE
      DO 90 I = 1,N
        SIGMA(I) = SQRT((SUM - RESID(I)*RESID(I)/(ONE-HAT(I)))/DENOM)
   90 CONTINUE
      RETURN
      END
