\name{esoph}
\title{Smoking, Alcohol and (O)esophageal Cancer}
\usage{data(esoph)}
\alias{esoph}
\format{data frame with records for 88 age/alcohol/tobacco combinations.
  \tabular{rlll}{
    [,1] \tab "agegp" \tab Age group \tab 1  25-34 years \cr
    \tab \tab \tab 2  35-44 \cr
    \tab \tab \tab 3  45-54 \cr
    \tab \tab \tab 4  55-64 \cr
    \tab \tab \tab 5  65-74 \cr
    \tab \tab \tab 6  75+ \cr
    [,2] \tab "alcgp" \tab Alcohol consumption \tab 1   0-39 gm/day \cr
    \tab \tab \tab 2  40-79 \cr
    \tab \tab \tab 3  80-119 \cr
    \tab \tab \tab 4  120+ \cr
    [,3] \tab "tobgp" \tab Tobacco consumption \tab 1   0- 9 gm/day \cr
    \tab \tab \tab 2  10-19 \cr
    \tab \tab \tab 3  20-29 \cr
    \tab \tab \tab 4  30+ \cr
    [,4] \tab "ncases" \tab Number of cases \tab \cr
    [,5] \tab "ncontrols"  \tab Number of subjects \tab  \cr
  }
}
\source{Breslow and Day (1980).
 "Statistical Methods in Cancer Research.
  1: The Analysis of Case-control studies"; IARC Lyon.
}
\author{Thomas Lumley}
\description{Data from a case-control study of (o)esophageal cancer in
  Ile-et-Vilaine, France.
}
\examples{
data(esoph)
summary(esoph)
## effects of alcohol, tobacco and interaction, age-adjusted
model1 <- glm(cbind(ncases, ncontrols) ~ agegp + tobgp * alcgp,
              data = esoph, family = binomial())
anova(model1)
## Try a linear effect of alcohol and tobacco
model2 <- glm(cbind(ncases, ncontrols) ~ agegp + codes(tobgp) + codes(alcgp),
              data = esoph, family = binomial())
summary(model2)
}
\keyword{datasets}
