\name{ftable}
\alias{ftable}
\alias{ftable.default}
\alias{print.ftable}
\alias{ftable2table}
\title{Flat Contingency Tables}
\description{Create and manipulate ``flat'' contingency tables.}
\synopsis{
ftable(x, ...)
ftable.default(..., exclude = c(NA, NaN), row.vars = NULL, col.vars = NULL)
print.ftable(x)
ftable2table(x)
}
\usage{
ftable(\dots, exclude = c(NA, NaN), row.vars = NULL, col.vars = NULL)
ftable2table(x)
}
\arguments{
  \item{\dots}{\R objects which can be interpreted as factors (including
    character strings), or a list (or data frame) whose components can
    be so interpreted, or a contingency table object of class
    \code{"table"} or \code{"ftable"}.}
  \item{exclude}{values to use in the exclude argument of \code{factor}
    when interpreting non-factor objects.}
  \item{row.vars}{a vector of integers giving the numbers of the
    variables, or a character vector giving the names of the variables
    to be used for the rows of the flat contingency table.}
  \item{col.vars}{a vector of integers giving the numbers of the
    variables, or a character vector giving the names of the variables
    to be used for the columns of the flat contingency table.}
  \item{x}{an arbitrary \R object.}
}
\value{
  \code{ftable} returns an object of class \code{"ftable"}, which is a
  matrix with counts of each combination of the levels of variables with
  information on the names and levels of the (row and columns) variables
  stored as attributes \code{"row.vars"} and \code{"col.vars"}.
}
\details{
  \code{ftable} creates ``flat'' contingency tables.  Similar to the
  usual contingency tables, these contain the counts of each combination
  of the levels of the variables (factors) involved.  This information
  is then re-arranged as a matrix whose rows and columns correspond to
  unique combinations of the levels of the row and column variables (as
  specified by \code{row.vars} and \code{col.vars}, respectively).  The
  combinations are created by looping over the variables in reverse
  order (so that the levels of the ``left-most'' variable vary the
  slowest).  Displaying a contingency table in this flat matrix form
  (via \code{print.ftable}, the print method for objects of class
  \code{"ftable"}) is often preferable to showing it as a
  higher-dimensional array.

  \code{ftable} is a generic function.  Its default method,
  \code{ftable.default}, first creates a contingency table in array
  form from all arguments except \code{row.vars} and \code{col.vars}.
  If the first argument is of class \code{"table"}, it represents a
  contingency table and is used as is; if it is a flat table of class
  \code{"ftable"}, the information it contains is converted to the usual
  array representation using \code{ftable2table}.  Otherwise, the
  arguments should be \R objects which can be interpreted as factors
  (including character strings), or a list (or data frame) whose
  components can be so interpreted, which are cross-tabulated using
  \code{\link{table}}.  Then, the arguments \code{row.vars} and
  \code{col.vars} are used to collapse the contingency table into flat
  form.  If neither of these two is given, the last variable is used for
  the columns.  If both are given and their union is a proper subset of
  all variables involved, the other variables are summed out.

  Function \code{\link{ftable.formula}} provides a formula method for
  creating flat contingency tables.

  \code{ftable2table} converts a contingency table in flat matrix form
  to one in standard array form.
}
\seealso{
  \code{\link{ftable.formula}} for the formula interface (which allows a
  \code{data = .} argument);
  \code{\link{table}} for ``ordinary'' cross-tabulation.
}
\examples{
## Start with a contingency table.
data(Titanic)
ftable(Titanic, row.vars = 1:3)
ftable(Titanic, row.vars = 1:2, col.vars = "Survived")
ftable(Titanic, row.vars = 2:1, col.vars = "Survived")

## Start with a data frame.
data(mtcars)
x <- ftable(mtcars[c("cyl", "vs", "am", "gear")])
x
ftable(x, row.vars = c(2, 4))
}
\keyword{category}
