% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regsel_f.R
\name{regsel_f}
\alias{regsel_f}
\alias{print.regsel_f}
\alias{plot.regsel_f}
\title{Regressors selection}
\usage{
regsel_f(
  model,
  pval = 0.3,
  metric = "adjr" & "aic",
  progress = FALSE,
  details = FALSE,
  ...
)

\method{print}{regsel_f}(x, ...)

\method{plot}{regsel_f}(x, print_plot = TRUE, ...)
}
\arguments{
\item{model}{is a linear regression model}

\item{pval}{p value; variables with p value less than \code{pval} will
enter into the model}

\item{metric}{statistical metrics used to estimate the best model}

\item{progress}{Logical; if TRUE, will display variable selection progress.}

\item{details}{Logical; if \code{TRUE}, will print the regression result at
each step.}

\item{...}{other arguments}

\item{x}{An object.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\value{
An object containing the following components:
\item{model}{final model; an object of class \code{lm}}
\item{steps}{number of steps}
\item{predictors}{variables added to the model}
\item{rsquare}{coefficient of determination}
\item{aic}{akaike information criteria}
\item{sbc}{bayesian information criteria}
\item{sbic}{sawa's bayesian information criteria}
\item{adjr}{adjusted r-square}
\item{rmse}{root mean square error}
\item{mallows_cp}{mallow's Cp}
\item{indvar}{predictors}
}
\description{
The function allows to choose regressors based on multiple criteria as {AIC}, {RMSE} etc
}
\references{
Hebbali, Aravind. Published 2020-02-10. olssr package
}
