% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readAnnotation.R
\name{readTextGridFast}
\alias{readTextGridFast}
\title{Reads a TextGrid made with praat and returns a list with a vector of all tier names and a data.frame for each tier.}
\usage{
readTextGridFast(File, Encoding)
}
\arguments{
\item{File}{Name (with full path, if not in wd) of the TextGrid}

\item{Encoding}{Encoding of the TextGrid. Typically encodings are "ACSII","UTF-8" or "UTF-16"}
}
\value{
A list containing a vectors with the names and data.frames for each tier in the TextGrid.
}
\description{
Reads a TextGrid made with praat and returns a list with a vector of all tier names and a data.frame for each tier.
}
\details{
This method has sometimes problems with certain sequences like "\\n" in the annotation file. 
If the method fails, try readTextGridRobust()
}
\examples{
       \dontrun{
       # Assume that NameOfTextGrid is encoded in "UTF-8"
       Data=readTextGridFast("NameOfTextGrid","UTF-8")

       }
}
\author{
Denis Arnold
}
