% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_trimDate.R
\name{monitor_trimDate}
\alias{monitor_trimDate}
\title{Trim a \emph{mts_monitor} object to full days}
\usage{
monitor_trimDate(monitor = NULL, timezone = NULL, trimEmptyDays = TRUE)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{timezone}{Olson timezone used to interpret dates.}

\item{trimEmptyDays}{Logical specifying whether to remove days with no data
at the beginning and end of the time range.}
}
\value{
A subset of the given \emph{mts_monitor} object. (A list with
\code{meta} and \code{data} dataframes.)
}
\description{
Trims the date range of a \emph{mts_monitor} object to local time date
boundaries which are \emph{within} the range of data. This has the effect
of removing partial-day data records at the start and end of the timeseries
and is useful when calculating full-day statistics.

By default, multi-day periods of all-missing data at the beginning and end
of the timeseries are removed before trimming to date boundaries. If
\code{trimEmptyDays = FALSE} all records are retained except for partial days
beyond the first and after the last date boundary.

Day boundaries are calculated using the specified \code{timezone} or, if
\code{NULL}, from \code{monitor$meta$timezone}.
}
\examples{
library(AirMonitor)

# Non-day boundaries
monitor <-
  Camp_Fire \%>\%
  monitor_filterDatetime(
    "2018111502",
    "2018112206",
    timezone = "America/Los_Angeles"
  )

monitor \%>\%
  monitor_timeRange(timezone = "America/Los_Angeles")

# Trim to full days only
monitor \%>\%
  monitor_trimDate() \%>\%
  monitor_timeRange(timezone = "America/Los_Angeles")

}
