% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PurpleAirSoH_dailyPctDC.R
\name{PurpleAirSoH_dailyPctDC}
\alias{PurpleAirSoH_dailyPctDC}
\title{Daily DC Signal percentage}
\usage{
PurpleAirSoH_dailyPctDC(pat = NULL)
}
\arguments{
\item{pat}{PurpleAir Timeseries \emph{pat} object.}
}
\description{
This function calculates the daily percentage of DC signal 
recorded by the \code{pm25_A}, \code{pm25_B}, \code{humidity}, and 
\code{temperature} channels. The data are flagged as DC signal when the 
standard deviation of an hour of data from each channel equals zero.
The number of hours with a DC signal are summed over the day and a daily DC 
percentage for each channel is returned. 

This metric allows users to identify “sticky values”, or instances of a sensor 
continuously logging the same value. A high percent DC value indicates the 
likely occurrence of a “sticky value”, and a zero or low percent DC indicates 
that the sensor is recording dynamic data.
}
\examples{
 
library(AirSensor)

tbl <- 
  example_pat_failure_A \%>\%
  PurpleAirSoH_dailyPctDC() 

timeseriesTbl_multiPlot(tbl, ylim = c(0,100))
}
