% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_monitorComparison.R
\name{pat_monitorComparison}
\alias{pat_monitorComparison}
\title{Comparison of Purple Air and federal monitoring data}
\usage{
pat_monitorComparison(
  pat = NULL,
  FUN = AirSensor::PurpleAirQC_hourly_AB_01,
  distanceCutoff = 20,
  ylim = NULL,
  replaceOutliers = TRUE,
  timezone = NULL
)
}
\arguments{
\item{pat}{PurpleAir Timeseries \emph{pat} object.}

\item{FUN}{Algorithm applied to \emph{pat} object for hourly aggregation and 
quality control. See \code{pat_createAirSensor()} for more details.}

\item{distanceCutoff}{Numeric distance (km) cutoff for nearest PWFSL monitor.}

\item{ylim}{Vector of (lo,hi) y-axis limits.}

\item{replaceOutliers}{Logical specifying whether replace outliers in the
\emph{pat} object.}

\item{timezone}{Olson timezone used for the time axis. (Defaults to 
\code{pat} local time.)}
}
\value{
A ggplot object.
}
\description{
Creates and returns a ggplot object that plots raw \emph{pat}
data, hourly aggregated \emph{pat} data and hourly data from the nearest
federal monitor from the PWFSL database.
}
\examples{
\donttest{
library(AirSensor)

pat_monitorComparison(example_pat)
}

}
