% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection_functions.R
\name{preselrandom}
\alias{preselrandom}
\title{Randomly preselecting offspring}
\usage{
preselrandom(gen, batch = 0, withinfam = TRUE, Nenv, Npresel)
}
\arguments{
\item{gen}{The generation of the offspring.}

\item{batch}{The batch of the offspring that need to be randomly preselected. Default is 0.}

\item{withinfam}{Preselection within a full sib family or not, default is TRUE.}

\item{Nenv}{The number of environments the fish need to be preselected for, for example a certain number of fish need to be preselected for a nucleus and a certain number of fish need to be preselected for a production environment in order to measure sib traits.}

\item{Npresel}{The number of fish that needs to be preselected for each environment.}
}
\value{
This function will make changes to the data frame called 'ped'. Fish that are pre-selected will get a number assigned to their column 'preselected'.
}
\description{
This function can be used to randomly preselect offspring or randomly allocate offspring to for example the nucleus and prodction environment.
}
\examples{
\donttest{ped <- founderpopfam(Nm = 60,
                     Nf = 60,
                     Nm2 = 0,
                     Nf2 = 0,
                     Ntraits = 2,
                     TraitsIndex = 2,
                     Rgen = matrix(c(1.00   , 0.48,
                                    0.48   , 1.00),
                                 nrow = 2),
                     Rcom = matrix(c(1.00  , 0.5,
                                    0.5   , 1.00),
                                 nrow = 2),
                     Rres = matrix(c(1.00   , 0.32,
                                    0.32   , 1.00),
                                 nrow = 2),
                     mean = c(50,500),
                     a_var = c(200,8000),
                     c_var = c(150,1000),
                     e_var = c(250,12000))
                     
Mating <- randommating(gen = 0,
                       Nfam_FS = 120)

for(fam in 1: nrow(Mating)){
ped <- offspringFSfam(gen = 1,
                      No = 100,
                      probmale = 0.5,
                      sire = Mating$Sire[fam],
                      dam = Mating$Dam[fam],
                      Ntraits = 2,
                      TraitsIndex = 2,
                      Rgen = matrix(c(1.00   , 0.48,
                                    0.48   , 1.00),
                                 nrow = 2),
                      Rcom = matrix(c(1.00  , 0.5,
                                    0.5   , 1.00),
                                 nrow = 2),
                      Rres = matrix(c(1.00   , 0.32,
                                    0.32   , 1.00),
                                 nrow = 2),
                      a_var = c(200,8000),
                      c_var = c(150,1000),
                      e_var = c(250,12000))
}

ped <- preselrandom(gen = 1,
                    Nenv = 2,
                    Npresel = c(25,15))
}
}
