% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.historylabels.R
\name{list.historylabels}
\alias{list.historylabels}
\title{List all the observable partial capture histories}
\usage{
list.historylabels(t,t.max=15)
}
\arguments{
\item{t}{a positive integer representing the total number of trapping occasions}

\item{t.max}{a positive integer representing upper bound on the total number of trapping occasions allowed.}
}
\value{
A list of all the observable partial capture histories which can be recorded in a discrete-time capture-recapture setting with t consecutive trapping occasions. If \code{t>t.max} the function stops with an error message.
}
\description{
This function returns a list of all the observable partial capture histories which can be recorded in a discrete-time capture-recapture setting with \eqn{t} consecutive trapping occasions. The observable partial capture histories are \eqn{2^t-1}
}
\details{
For obvious computing/memory reasons t is not allowed to be arbitrarily large. With \code{t.max=15} there are 32767 possible partial capture histories. If \code{t>t.max} the function stops with an error message.
}
\examples{

list.historylabels(t=4)

}
\seealso{
\code{\link{partition.ch}}
}
\author{
Danilo Alunni Fegatelli and Luca Tardella
}
