% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.estimate.R
\name{select.estimate}
\alias{select.estimate}
\title{Graph Selection for \code{estimate} Objects}
\usage{
\method{select}{estimate}(object, cred = 0.95, alternative = "two.sided", ...)
}
\arguments{
\item{object}{An object of class \code{estimate.default}.}

\item{cred}{Numeric. The credible interval width for selecting the graph
(defaults to 0.95; must be between 0 and 1).}

\item{alternative}{A character string specifying the alternative hypothesis. It
must be one of "two.sided" (default), "greater"  or "less".
See note for futher details.}

\item{...}{Currently ignored.}
}
\value{
The returned object of class \code{select.estimate} contains a lot of information that
        is used for printing and plotting the results. For users of \strong{BGGM}, the following
        are the useful objects:

\itemize{

\item \code{pcor_adj} Selected partial correlation matrix (weighted adjacency).
\item \code{adj} Adjacency matrix for the selected edges
\item \code{object} An object of class \code{estimate} (the fitted model).

}
}
\description{
Provides the selected graph based on credible intervals for
the partial correlations that did not contain zero
\insertCite{Williams2019}{BGGM}.
}
\details{
This package was built for the social-behavioral sciences in particular. In these applications, there is
strong theory that expects \emph{all} effects to be positive. This is known as a "positive manifold" and
this notion has a rich tradition in psychometrics. Hence, this can be incorporated into the graph with
\code{alternative = "greater"}. This results in the estimated structure including only positive edges.
}
\examples{
\donttest{
# note: iter = 250 for demonstrative purposes

# data
Y <- bfi[,1:10]

# estimate
fit <- estimate(Y, iter = 250,
                progress = FALSE)


# select edge set
E <- select(fit)

}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{estimate}} and \code{\link{ggm_compare_estimate}} for several examples.
}
