% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{bhai.prettyTable}
\alias{bhai.prettyTable}
\title{Create summary table}
\usage{
bhai.prettyTable(pps, pop_norm=FALSE, conf.int=TRUE)
}
\arguments{
\item{pps}{The PPS object containing the data.}

\item{pop_norm}{Indicating whether statistics should be computed per 100,000 population, default: TRUE.}

\item{conf.int}{Specifying whether confidence intervals should be computed, default: TRUE.}
}
\value{
A data.frame containing the summarised results.
}
\description{
Create BHAI summary table
}
\examples{

data(german_pps_2011_repr)
german_pps_repr = PPS(num_hai_patients = num_hai_patients,
    num_hai_patients_by_stratum = num_hai_patients_by_stratum,
    num_hai_patients_by_stratum_prior = num_hai_patients_by_stratum_prior,
    num_survey_patients = num_survey_patients,
    length_of_stay = length_of_stay,
    loi_pps = loi_pps,
    mccabe_scores_distr = mccabe_scores_distr,
    mccabe_life_exp = mccabe_life_exp,
    hospital_discharges = hospital_discharges,
    population = population,
    country="Germany (representative sample)")
german_pps_repr

set.seed(3)
# The following example is run only for illustratory reasons
# Note that you should never run the function with only 10 Monte-Carlo simulations in practice!
result = bhai(german_pps_repr, nsim=10)
bhai.prettyTable(result)
  
}
\seealso{
\code{\linkS4class{PPS}}
}
