% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareRecords.R
\name{compareRecords}
\alias{compareRecords}
\title{Creation of Comparison Data}
\usage{
compareRecords(
  df1,
  df2,
  flds = NULL,
  flds1 = NULL,
  flds2 = NULL,
  types = NULL,
  breaks = c(0, 0.25, 0.5)
)
}
\arguments{
\item{df1, df2}{two datasets to be linked, of class \code{data.frame}, with rows representing records and columns
representing fields.  Without loss of generality, 
\code{df1} is assumed to have no less records than \code{df2}.}

\item{flds}{a vector indicating the fields to be used in the linkage.  Either a \code{character} vector, in which case
all entries need to be names of columns of \code{df1} and \code{df2}, or a \code{numeric} vector
indicating the columns in \code{df1} and \code{df2} to be used in the linkage.  If provided as a 
\code{numeric} vector it is assumed that the columns of \code{df1} and \code{df2} are organized such that 
it makes sense to compare the columns
\code{df1[,flds]} and \code{df2[,flds]} in that order.}

\item{flds1, flds2}{vectors indicating the fields of \code{df1} and \code{df2} to be used in the linkage.
    Either \code{character} vectors, in which case  
    all entries need to be names of columns of \code{df1} and \code{df2}, respectively, or \code{numeric} vectors
    indicating the columns in \code{df1} and \code{df2} to be used in the linkage.  It is assumed that
it makes sense to compare the columns
    \code{df1[,flds1]} and \code{df2[,flds2]} in that order.  These arguments are ignored if \code{flds} is specified.
If none of \code{flds,flds1,flds2} are specified, the columns with the same names in \code{df1} and \code{df2} 
are compared, if any.}

\item{types}{a vector of characters indicating the comparison type per comparison field.  The options
are: \code{"lv"} for comparisons based on the Levenshtein edit distance normalized to \eqn{[0,1]}, with \eqn{0}  
indicating no disagreement and \eqn{1} indicating maximum disagreement;  
\code{"bi"} for binary comparisons (agreement/disagreement); \code{"nu"} for numeric comparisons computed as 
the absolute difference. 
    The default is \code{"lv"}.  Fields compared with the \code{"lv"} option are first transformed to \code{character}
class.  Factors with different levels compared using the \code{"bi"} option are transformed to factors with the union 
    of the levels.  Fields compared with the \code{"nu"} option need to be of class \code{numeric}.}

\item{breaks}{break points for the comparisons to obtain levels of disagreement.
It can be a list of length equal to the number of comparison fields, containing one numeric vector with the break 
points for each comparison field, where entries corresponding to comparison type \code{"bi"} are ignored.  
It can also be a named list of length two with elements 'lv' and 'nu' 
containing numeric vectors with the break 
points for all Levenshtein-based and numeric comparisons, respectively.  
Finally, it can be a numeric vector with the break points for all comparison fields of type \code{"lv"} and \code{"nu"},
which might be meaningful only if all the non-binary comparisons are of a single type, either \code{"lv"} or \code{"nu"}.  
For comparisons based on the normalized Levenshtein distance, a vector of length \eqn{L} of break 
points for the interval \eqn{[0,1]} leads to \eqn{L+1} levels of disagreement.  Similarly, for comparisons based on the absolute 
difference, the break points are for the interval \eqn{[0,\infty)}.  
The default is \code{breaks=c(0,.25,.5)}, which might be meaningful only for comparisons of type \code{"lv"}.}
}
\value{
a list containing: 
\describe{
  \item{\code{comparisons}}{
						matrix with \code{n1*n2} rows, where the comparison pattern for record pair \eqn{(i,j)}
					appears in row \code{(j-1)*n1+i}, for \eqn{i} in \eqn{{1,\dots,n1}}, and \eqn{j} in \eqn{{1,\dots,n2}}.  
					A comparison field with \eqn{L+1} levels of disagreement, 
					is represented by \eqn{L+1} columns of TRUE/FALSE indicators.  Missing comparisons are coded as FALSE,
					which is justified under an assumption of ignorability of the missing comparisons, see Sadinle (2017).
					}
  \item{\code{n1,n2}}{the datafile sizes, \code{n1 = nrow(df1)} and \code{n2 = nrow(df2)}.}
  \item{\code{nDisagLevs}}{a vector containing the number of levels of
				 	disagreement per comparison field.}
  \item{\code{compFields}}{a data frame containing the names of the fields in the datafiles used in the comparisons 
				 	and the types of comparison.}
}
}
\description{
Create comparison vectors for all pairs of records coming from 
two datafiles to be linked.
}
\examples{
data(twoFiles)

myCompData <- compareRecords(df1, df2, 
                             flds=c("gname", "fname", "age", "occup"),
                             types=c("lv","lv","bi","bi"), 
                             breaks=c(0,.25,.5))

## same as 
myCompData <- compareRecords(df1, df2, types=c("lv","lv","bi","bi"))


## let's transform 'occup' to numeric to illustrate how to obtain numeric comparisons 
df1$occup <- as.numeric(df1$occup)
df2$occup <- as.numeric(df2$occup)

## using different break points for 'lv' and 'nu' comparisons 
myCompData1 <- compareRecords(df1, df2, 
                              flds=c("gname", "fname", "age", "occup"),
                              types=c("lv","lv","bi","nu"), 
                              breaks=list(lv=c(0,.25,.5), nu=0:3))

## using different break points for each comparison field
myCompData2 <- compareRecords(df1, df2, 
                              flds=c("gname", "fname", "age", "occup"),
                              types=c("lv","lv","bi","nu"), 
                              breaks=list(c(0,.25,.5), c(0,.2,.4,.6), NULL, 0:3))
}
\references{
Mauricio Sadinle (2017). Bayesian Estimation of Bipartite Matchings for Record Linkage. \emph{Journal of the
American Statistical Association} 112(518), 600-612. [\href{https://doi.org/10.1080/01621459.2016.1148612}{Published}] [\href{https://arxiv.org/abs/1601.06630}{arXiv}]
}
