% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Board}
\alias{Board}
\title{Incomes of board members from three different universities}
\format{
A data frame/tibble with 7 observations on three variables
\describe{ 
\item{salary}{1999 salary (in $1000) for board directors} 
\item{university}{a factor with levels \code{A}, \code{B}, and \code{C}} 
}
}
\usage{
Board
}
\description{
Data for Exercise 10.14
}
\examples{

boxplot(salary ~ university, data = Board, col = c("red", "blue", "green"), 
        ylab = "Income")
tapply(Board$salary, Board$university, summary)
anova(lm(salary ~ university, data = Board))
\dontrun{
library(dplyr)
dplyr::group_by(Board, university) \%>\%
         summarize(Average = mean(salary))
}
}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
