% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbg-cnbd-k.R
\name{mbgcnbd.PlotTrackingInc}
\alias{mbgcnbd.PlotTrackingInc}
\alias{bgcnbd.PlotTrackingInc}
\title{(M)BG/CNBD-k Tracking Incremental Transactions Comparison}
\usage{
mbgcnbd.PlotTrackingInc(
  params,
  T.cal,
  T.tot,
  actual.inc.tracking.data,
  xlab = "Week",
  ylab = "Transactions",
  xticklab = NULL,
  title = "Tracking Weekly Transactions",
  ymax = NULL,
  legend = c("Actual", "Model")
)

bgcnbd.PlotTrackingInc(
  params,
  T.cal,
  T.tot,
  actual.inc.tracking.data,
  xlab = "Week",
  ylab = "Transactions",
  xticklab = NULL,
  title = "Tracking Weekly Transactions",
  ymax = NULL,
  legend = c("Actual", "Model")
)
}
\arguments{
\item{params}{A vector with model parameters \code{k}, \code{r},
\code{alpha}, \code{a} and \code{b}, in that order.}

\item{T.cal}{A vector to represent customers' calibration period lengths.}

\item{T.tot}{End of holdout period. Must be a single value, not a vector.}

\item{actual.inc.tracking.data}{A vector containing the incremental number of
repeat transactions made by customers for each period in the total time
period (both calibration and holdout periods).}

\item{xlab}{Descriptive label for the x axis.}

\item{ylab}{Descriptive label for the y axis.}

\item{xticklab}{A vector containing a label for each tick mark on the x axis.}

\item{title}{Title placed on the top-center of the plot.}

\item{ymax}{Upper boundary for y axis.}

\item{legend}{plot legend, defaults to `Actual` and `Model`.}
}
\value{
Matrix containing actual and expected incremental repeat transactions.
}
\description{
Plots the actual and expected incremental total repeat transactions by all
customers for the calibration and holdout periods, and returns this
comparison in a matrix.
}
\details{
Note: Computational time increases with the number of unique values of
\code{T.cal}.
}
\examples{
\dontrun{
data("groceryElog")
groceryElog <- groceryElog[groceryElog$date < "2006-06-30", ]
cbs <- elog2cbs(groceryElog, T.cal = "2006-04-30")
inc <- elog2inc(groceryElog)
params <- mbgcnbd.EstimateParameters(cbs, k = 2)
mbgcnbd.PlotTrackingInc(params, cbs$T.cal,
  T.tot = max(cbs$T.cal + cbs$T.star), inc)
}
}
\seealso{
\code{\link{mbgcnbd.ExpectedCumulativeTransactions}}
}
