% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{plotTimingPatterns}
\alias{plotTimingPatterns}
\title{Plot timing patterns of sampled customers}
\usage{
plotTimingPatterns(
  elog,
  n = 40,
  T.cal = NULL,
  T.tot = NULL,
  title = "Sampled Timing Patterns",
  headers = NULL
)
}
\arguments{
\item{elog}{Event log, a \code{data.frame} with columns \code{cust} and
transaction time \code{t} or \code{date}.}

\item{n}{Number of sampled customers.}

\item{T.cal}{End of calibration period, which is visualized as a vertical line.}

\item{T.tot}{End of observation period}

\item{title}{Plot title.}

\item{headers}{Vector of length 2 for adding headers to the plot, e.g.
\code{c("Calibration", "Holdout")}.}
}
\description{
Plot timing patterns of sampled customers
}
\examples{
data("groceryElog")
plotTimingPatterns(groceryElog, T.tot = "2008-12-31")
plotTimingPatterns(groceryElog, T.cal = "2006-12-31", headers = c("Calibration", "Holdout"))
}
