% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/class_definitions.R
\docType{class}
\name{jumpDiffusion-class}
\alias{jumpDiffusion-class}
\title{S4 class of model informations for the jump diffusion process}
\description{
Informations of model
\eqn{dY_t = b(\phi,t,Y_t)dt + s(\gamma^2,t,Y_t)dW_t + h(\theta,t,Y_t)dN_t} with
\eqn{N_t\sim Pois(\Lambda(t, \xi))}.
}
\section{Slots}{

\describe{
\item{\code{theta}}{parameter \eqn{\theta}}

\item{\code{phi}}{parameter \eqn{\phi}}

\item{\code{gamma2}}{parameter \eqn{\gamma^2}}

\item{\code{xi}}{parameter \eqn{\xi}}

\item{\code{b.fun}}{function \eqn{b(\phi,t,y)}}

\item{\code{s.fun}}{function \eqn{s(\gamma^2,t,y)}}

\item{\code{h.fun}}{function \eqn{b(\theta,t,y)}}

\item{\code{Lambda}}{function \eqn{\Lambda(t,\xi)}}

\item{\code{priorDensity}}{list of prior density functions, default is a non-informative approach}

\item{\code{start}}{list of starting values for the Metropolis within Gibbs sampler}
}}
\examples{
parameter <- list(phi = 0.01, theta = 0.1, gamma2 = 0.01, xi = c(2, 0.2))
b.fun <- function(phi, t, y) phi * y
s.fun <- function(gamma2, t, y) sqrt(gamma2) * y
h.fun <- function(theta, t, y) theta * y
Lambda <- function(t, xi) (t / xi[2])^xi[1]
priorDensity <- list(
  phi = function(phi) 1,
  theta = function(theta) dnorm(theta, 0.1, 0.001),
  gamma2 = function(gamma2) dgamma(1/gamma2, 3, 0.01*2),
  xi = function(xi) dgamma(xi, c(2, 0.2), 1)
)
start <- parameter
model <- set.to.class("jumpDiffusion", parameter, start = start,
  b.fun = b.fun, s.fun = s.fun, h.fun = h.fun, Lambda = Lambda,
  priorDensity = priorDensity)
}

