% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.R
\docType{methods}
\name{plot,est.hiddenmixedDiffusion-method}
\alias{plot,est.hiddenmixedDiffusion-method}
\title{Plot method for the Bayesian estimation results}
\usage{
\S4method{plot}{est.hiddenmixedDiffusion}(x, par.options, style = c("chains",
  "acf", "density", "int.phi"), par2plot, reduced = FALSE, thinning, burnIn,
  priorMeans = TRUE, col.priorMean = 2, lty.priorMean = 1, level = 0.05,
  phi, ...)
}
\arguments{
\item{x}{est.hiddenmixedDiffusion class, created with method \code{\link{estimate,hiddenmixedDiffusion-method}}}

\item{par.options}{list of options for function par()}

\item{style}{one out of "chains", "acf", "density", "int.phi"}

\item{par2plot}{logical vector, which parameters to be plotted, order: \eqn{(\mu, \Omega, \gamma^2, \sigma^2, Y)}}

\item{reduced}{logical (1), if TRUE, the chains are thinned and burn-in phase is dropped}

\item{thinning}{thinning rate, if missing, the proposed one by the estimation procedure is taken}

\item{burnIn}{burn-in phase, if missing, the proposed one by the estimation procedure is taken}

\item{priorMeans}{logical(1), if TRUE (default), prior means are marked with a line}

\item{col.priorMean}{color of the prior mean line, default 2}

\item{lty.priorMean}{linetype of the prior mean line, default 1}

\item{level}{level for style = "int.phi"}

\item{phi}{in the case of simulation study: known values for phi}

\item{...}{optional plot parameters}
}
\description{
Plot method for the estimation results of the hidden hierarchical diffusion model.
}
\examples{
\dontrun{
mu <- c(10, 3, 1); Omega = c(1, 0.4, 0.01)
phi <- sapply(1:3, function(i) rnorm(20, mu[i], sqrt(Omega[i])))
model <- set.to.class("hiddenmixedDiffusion", b.fun = function(phi, t, y) phi[1]-phi[2]*y,
    parameter = list(mu = mu, Omega = Omega, phi = phi, gamma2 = 1, sigma2 = 0.1),
    y0 = function(phi, t) phi[3])
data <- simulate(model, t = seq(0, 1, by = 0.02), plot.series = TRUE)
est <- estimate(model, t = seq(0, 1, by = 0.02), data$Z, 1000)
plot(est, burnIn = 10, thinning = 2, reduced = TRUE)
plot(est, par.options = list(mar = c(5, 4.5, 4, 2) + 0.1, mfrow = c(2,1)), xlab = "iteration")
plot(est, style = "acf", main = "", par2plot = c(TRUE, TRUE, rep(FALSE, 7)))
plot(est, style = "density", lwd = 2, priorMean = FALSE,
   par2plot = c(rep(FALSE, 6), TRUE, TRUE, FALSE))
plot(est, style = "density", col.priorMean = 1, lty.priorMean = 2, main = "posterior")
plot(est, style = "acf", par.options = list(), main = "", par2plot = c(rep(FALSE, 6), TRUE, TRUE))
plot(est, style = "int.phi", phi = phi, par2plot = c(TRUE, FALSE, FALSE))
}
}

