% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/independent.R
\name{independent}
\alias{independent}
\title{Independence of the sets}
\usage{
independent(object, sets)
}
\arguments{
\item{object}{A \code{\link{TidySet}} object.}

\item{sets}{A character vector with the names of the sets to analyze.}
}
\value{
A logical value indicating if the sets are independent (TRUE) or not.
}
\description{
Checks if the elements of the sets are present in more than one set.
}
\examples{
x <- list("A" = letters[1:5], "B" = letters[3:7], "C" = letters[6:10])
TS <- tidySet(x)
independent(TS)
independent(TS, c("A", "B"))
independent(TS, c("A", "C"))
independent(TS, c("B", "C"))
}
