% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obo.R
\name{getOBO}
\alias{getOBO}
\title{Read an OBO file}
\usage{
getOBO(x)
}
\arguments{
\item{x}{Path to a file in OBO format.}
}
\value{
A TidySet object.
}
\description{
Read an Open Biological and Biomedical Ontologies (OBO) formatted file
}
\examples{
oboFile <- system.file(
    package = "BaseSet", "extdata",
    "go-basic_subset.obo"
)
gs <- getOBO(oboFile)
head(gs)
}
\references{
The format is described \href{https://owlcollab.github.io/oboformat/doc/GO.format.obo-1_4.html}{here}
}
\seealso{
Other IO functions: 
\code{\link{getGAF}()},
\code{\link{getGMT}()}
}
\concept{IO functions}
