% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ev.combo.R
\name{ev.combo}
\alias{ev.combo}
\title{Calculates the posterior probability of hypotheses for multiple
studies}
\usage{
ev.combo(beta, se.beta, beta0 = 0, ci = 99, H0 = c(0, 0), scale = FALSE,
  H.priors = rep(1/3, 3), se.mult = 1, adjust = FALSE, epsilon = 1e-06,
  adj.factor = 1e-04, ...)
}
\arguments{
\item{beta}{Effect size.}

\item{se.beta}{Standard error for the effect.}

\item{beta0}{A prior value for the effect size. Default is zero.}

\item{ci}{Is used to calculate the prior standard error if \code{se0 =
NULL}. The default value of 99 calculates the prior standard error so that
the 99% confidence intervals of the prior distribution are aligned with the
largest (furthest from zero) confidence interval of the data distribution.}

\item{H0}{A vector of length two that defines the null hypothesis. If the
values are identical (e.g. \code{H0 = c(0,0)}) a point null is used,
otherwise the null is defined as the range between the lower and upper value.}

\item{scale}{Logical. Whether to scale the effect size by its standard
error. Standardising has no effect on the calculations but standardised
effect sizes may be easier to compare in a forest plot.}

\item{H.priors}{Prior hypothesis probabilities; default is an equal
probability of 1/3, and they are specified in the following order:
\code{H<0}, \code{H=0}, \code{H>0}.}

\item{se.mult}{Standard error multiplier used to increase or decrease the
prior SE and used in conjunction with \code{ci} when \code{se0 = NULL}.}

\item{adjust}{Logical. Whether to adjust very small posterior hypothesis
probabilities. Adjusting prevents a single study from having too much
influence on the results when combining multiple studies. For example, if the
probability for a hypothesis from one study is zero, then additional studies
cannot alter this probability (multiplying anything by zero is still zero).}

\item{epsilon}{A small value that a posterior hypothesis probability must
fall below before an adjustment is made. Ignored if \code{adjust = FALSE}.}

\item{adj.factor}{A small number added to each posterior hypothesis
probability if \code{adjust = TRUE} and one of the posterior hypothesis
probabilities is less than \code{epsilon}. The PPHs are then re-scaled to sum
to one.}

\item{...}{Options to be passed to \code{pph()}.}
}
\value{
Object of class \code{EV} which contains a matrix of posterior
probabilities for each updated step and other calculated values.
}
\description{
The function takes multiple effect sizes and a their standard
errors and calculates the posterior probability for each hypothesis (H<: the
effect size is less than 0, H0: the effect size is zero, or H>: the effect
size is greater than zero).
}
\details{
This function calls \code{pph()} once for each study to be combined,
where the posterior probabilities for one study are used as the priors for
the next study. One exeption is that values for \code{se0} are ignored as
they are calculated automatically.
}
\examples{
x <- ev.combo(beta = c(0.0126, 5.0052, 1.2976, 0.0005),
       se.beta = c(0.050, 2.581, 2.054, 0.003) )
x
plot(x)
}

