% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calf_wrappers.R
\name{calf_exact_binary_subset}
\alias{calf_exact_binary_subset}
\title{calf_exact_binary_subset}
\usage{
calf_exact_binary_subset(
  data,
  nMarkers,
  nCase,
  nControl,
  times = 1,
  optimize = "pval",
  verbose = FALSE
)
}
\arguments{
\item{data}{Matrix or data frame. First column must contain case/control dummy coded variable.}

\item{nMarkers}{Maximum number of markers to include in creation of sum.}

\item{nCase}{Numeric. A value indicating the number of case data to use.}

\item{nControl}{Numeric. A value indicating the number of control data to use.}

\item{times}{Numeric. Indicates the number of replications to run with randomization.}

\item{optimize}{Criteria to optimize.  Indicate "pval" to optimize the p-value corresponding to the t-test distinguishing case and control. Indicate "auc" to optimize the AUC.}

\item{verbose}{Logical. Indicate TRUE to print activity at each iteration to console. Defaults to FALSE.}
}
\value{
A data frame containing the chosen markers and their assigned weight (-1 or 1)

The optimal AUC or pval for the classification. If multiple replications are requested, a data.frame containing all optimized values across all replications is returned.

aucHist A histogram of the AUCs across replications, if applicable.
}
\description{
Runs Coarse Approximation Linear Function on a random subset of binary data provided, with the ability to precisely control the number of case and control data used.
}
\examples{
calf_exact_binary_subset(data = CaseControl, nMarkers = 6, nCase = 5, nControl = 8, times = 5)
}
