% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_io.R
\name{post_data}
\alias{post_data}
\title{Save Reviewer Annotations}
\usage{
post_data(
  uri_fun,
  user,
  password,
  host,
  port,
  database,
  end_user,
  end_user_password,
  position,
  event_date,
  pt_comments,
  ldap = FALSE
)
}
\arguments{
\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}

\item{end_user}{CEDARS end user name.}

\item{end_user_password}{CEDARS end user password.}

\item{position}{Sentence position within the sequence of selected sentences for a given patient.}

\item{event_date}{Date of clinical event as determined by human reviewer.}

\item{pt_comments}{Patient-specific comments from the reviewer.}

\item{ldap}{Is LDAP authentication being used? If so, password will not be checked and access will be granted automatically.}
}
\description{
Saves sentence review status and event time about an individual for whom the electronic health record text was reviewed. Main way for end user to enter data into CEDARS.
}
\keyword{internal}
