% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{pre_search}
\alias{pre_search}
\title{Execute Search on a Set of Records}
\usage{
pre_search(patient_vect = NA, uri_fun, user, password, host, port, database)
}
\arguments{
\item{patient_vect}{Vector of patient ID's. Default is NA, in which case all unlocked records will be searched.}

\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}
}
\value{
{
No return value, called to execute a query in the database.
}
}
\description{
Batches a keyword/CUI search for a cohort of patients. Useful to speed up the process by end users, since search results will be pre-populated. Locks each record before proceeding with search on existing NLP annotations. Patient records with no matching sentences or a known event date at or before the earliest matching sentence will be marked as reviewed. The latter assumes the query orders to skip sentences after events.
}
\examples{
\dontrun{
pre_search(patient_vect = NA, uri_fun = mongo_uri_standard, user = 'John',
password = 'db_password_1234', host = 'server1234', database = 'TEST_PROJECT')
}
}
