% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_processing.R
\name{upload_notes}
\alias{upload_notes}
\title{Upload Notes to Database}
\usage{
upload_notes(uri_fun, user, password, host, port, database, notes)
}
\arguments{
\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}

\item{notes}{Dataframe of EHR documents with metadata. The documents can consist of full notes or note subsections.}
}
\value{
{
Confirmation that requested operation was completed, or error message if attempt failed.
}
}
\description{
Allows user to populate notes in database from dataframe; could be easily inserted into wrapper batch function to serially download from other DB etc. Notes dataframe must contain: 'patient_id', 'text_id' (a unique identifier for each text segment), along with 'text', 'text_date', 'doc_id' (designates unique EHR document) and ideally 'text_sequence' which indicates order of text section within document. 'doc_section_name' along 'text_tag_1' to 'text_tag_10' are optional. 'text_date' must be in format '\%Y-\%m-\%d'!
}
\examples{
\dontrun{
upload_notes(uri_fun = mongo_uri_standard, user = 'John', password = 'db_password_1234',
host = 'server1234', port = NA, database = 'TEST_PROJECT', notes = simulated_patients)
}
}
